/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.jdeparser.AbstractJClassDef;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJEnumConstant;
import org.jboss.jdeparser.ImplJSourceFile;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JClassItem;
import org.jboss.jdeparser.JEnumConstant;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class EnumJClassDef
extends AbstractJClassDef
implements JClassItem {
    private final Map<String, ImplJEnumConstant> constants = new LinkedHashMap<String, ImplJEnumConstant>();

    EnumJClassDef(int mods, ImplJSourceFile classFile, String name) {
        super(mods, classFile, name);
    }

    EnumJClassDef(int mods, AbstractJClassDef enclosingClass, String name) {
        super(mods, enclosingClass, name);
    }

    @Override
    Tokens$.KW designation() {
        return Tokens$.KW.ENUM;
    }

    @Override
    public JEnumConstant _enum(String name) {
        ImplJEnumConstant c = new ImplJEnumConstant(this, name);
        this.constants.put(name, c);
        return c;
    }

    @Override
    public JClassDef _extends(String name) {
        throw new UnsupportedOperationException("extends on enum");
    }

    @Override
    public JClassDef _extends(JType type) {
        throw new UnsupportedOperationException("extends on enum");
    }

    @Override
    public JClassDef _extends(Class<?> clazz) {
        throw new UnsupportedOperationException("extends on enum");
    }

    @Override
    void writeContent(SourceFileWriter sourceFileWriter) throws IOException {
        Iterator<ImplJEnumConstant> iterator = this.constants.values().iterator();
        if (iterator.hasNext()) {
            iterator.next().writeDirect(sourceFileWriter);
            while (iterator.hasNext()) {
                sourceFileWriter.write(Tokens$.PUNCT.COMMA);
                sourceFileWriter.write(FormatPreferences.Space.AFTER_COMMA_ENUM_CONSTANT);
                iterator.next().writeDirect(sourceFileWriter);
            }
            if (sourceFileWriter.getFormat().hasOption(FormatPreferences.Opt.ENUM_TRAILING_COMMA)) {
                sourceFileWriter.write(Tokens$.PUNCT.COMMA);
                sourceFileWriter.write(FormatPreferences.Space.AFTER_COMMA_ENUM_CONSTANT);
            }
        }
        sourceFileWriter.write(Tokens$.PUNCT.SEMI);
        sourceFileWriter.write(FormatPreferences.Space.AFTER_SEMICOLON);
        super.writeContent(sourceFileWriter);
    }

    @Override
    public JClassItem.Kind getItemKind() {
        return JClassItem.Kind.ENUM;
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

