/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.core.queries;

import java.util.ArrayDeque;

public class CoreAttributeConverter {
    private static final char DOT = '.';
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final char FF = '\f';
    private static final char CR = '\r';
    private static final char SPACE = ' ';

    public static final String[] convert(String ... nameOrPath) throws IllegalArgumentException {
        if (nameOrPath == null) {
            throw new IllegalArgumentException("Name or path value is null");
        }
        switch (nameOrPath.length) {
            case 0: {
                throw new IllegalArgumentException("Name or path value size is zero");
            }
            case 1: {
                int index;
                String str = nameOrPath[0];
                if (str == null) {
                    throw new IllegalArgumentException("Name or path value is null");
                }
                int len = str.length();
                if (str.indexOf(46) < 0) {
                    switch (len) {
                        case 0: {
                            throw new IllegalArgumentException("Empty name or path value");
                        }
                        case 1: {
                            switch (str.charAt(0)) {
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    throw new IllegalArgumentException("Name or path value starts with whitespace.");
                                }
                            }
                        }
                    }
                    switch (str.charAt(0)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            throw new IllegalArgumentException("Name or path value starts with whitespace.");
                        }
                    }
                    switch (str.charAt(len - 1)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            throw new IllegalArgumentException("Name or path value ends with whitespace.");
                        }
                    }
                    return nameOrPath;
                }
                char[] chars = nameOrPath[0].toCharArray();
                ConvertState s = ConvertState.DOT;
                int begIndex = 0;
                ArrayDeque<String> elements = null;
                block44: for (index = 0; index < len; ++index) {
                    char c = chars[index];
                    block17 : switch (s.ordinal()) {
                        case 0: {
                            switch (c) {
                                case '.': {
                                    throw new IllegalArgumentException("Name or path value contains empty path element");
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    throw new IllegalArgumentException("Path element starts with whitespace.");
                                }
                            }
                            s = ConvertState.CH;
                            continue block44;
                        }
                        case 1: {
                            switch (c) {
                                case '.': {
                                    throw new IllegalArgumentException("Path element ends with whitespace.");
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    continue block44;
                                }
                            }
                            s = ConvertState.CH;
                            continue block44;
                        }
                        case 2: {
                            switch (c) {
                                case '.': {
                                    if (elements == null) {
                                        elements = new ArrayDeque<String>(4);
                                    }
                                    elements.addLast(new String(chars, begIndex, index - begIndex));
                                    begIndex = index + 1;
                                    s = ConvertState.DOT;
                                    break block17;
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    s = ConvertState.SP;
                                }
                            }
                        }
                    }
                }
                switch (s.ordinal()) {
                    case 0: {
                        throw new IllegalArgumentException("Empty name or path value or last path element");
                    }
                    case 1: {
                        throw new IllegalArgumentException("Name or path value ends with space");
                    }
                }
                if (elements == null) {
                    return nameOrPath;
                }
                int n = 0;
                int count = elements.size();
                String[] paths = new String[count + 1];
                while ((paths[n++] = (String)elements.pollFirst()) != null) {
                }
                paths[count] = new String(chars, begIndex, index - begIndex);
                return paths;
            }
        }
        for (int i = 0; i < nameOrPath.length; ++i) {
            String item = nameOrPath[i];
            if (item == null) {
                throw new IllegalArgumentException("Name or path value at index " + i + " is null");
            }
            int itemLen = item.length();
            if (itemLen == 0) {
                throw new IllegalArgumentException("Name or path value at index " + i + " is empty String");
            }
            switch (item.charAt(0)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    throw new IllegalArgumentException("Name or path value at index " + i + " starts with whitespace");
                }
            }
            if (itemLen <= 0) continue;
            switch (item.charAt(itemLen - 1)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    throw new IllegalArgumentException("Name or path value at index " + i + " ends with whitespace");
                }
            }
        }
        return nameOrPath;
    }

    private CoreAttributeConverter() {
        throw new UnsupportedOperationException("Instances of CoreAttributeConverter are not allowed");
    }

    private static enum ConvertState {
        DOT,
        SP,
        CH;

    }
}

