/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import com.sun.enterprise.glassfish.bootstrap.cfg.ServerFiles;
import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextCfg;
import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextCfgFactory;
import com.sun.enterprise.glassfish.bootstrap.cp.ClassLoaderBuilder;
import com.sun.enterprise.glassfish.bootstrap.launch.GlassfishOsgiBootstrapClassLoader;
import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.jdke.props.EnvToPropsConverter;
import org.glassfish.main.jdke.props.SystemProperties;

public class GlassFishMain {
    private static final PrintStream STDOUT = System.out;

    public static void main(String[] args) {
        try {
            GlassFishMain.checkJdkVersion();
            String platformName = GlassFishMain.whichPlatform();
            SystemProperties.setProperty((String)GlassFishVariable.OSGI_PLATFORM.getPropertyName(), (String)platformName, (boolean)true);
            OsgiPlatform platform = OsgiPlatform.valueOf(platformName);
            STDOUT.println("Launching GlassFish on " + String.valueOf((Object)platform) + " platform");
            File installRoot = ServerFiles.detectInstallRoot();
            STDOUT.println("Resolved GlassFish install root: " + String.valueOf(installRoot));
            Properties properties = GlassFishMain.initProperties(args);
            STDOUT.println("Resolved properties: " + String.valueOf(properties));
            Path instanceRoot = GlassFishMain.findInstanceRoot(installRoot, properties);
            ServerFiles files = new ServerFiles(installRoot.toPath(), instanceRoot);
            StartupContextCfg cfg = StartupContextCfgFactory.createStartupContextCfg(platform, files, properties);
            ClassLoader osgiCL = ClassLoaderBuilder.createOSGiFrameworkLauncherCL(cfg, ClassLoader.getSystemClassLoader());
            try (GlassfishOsgiBootstrapClassLoader launcherCL = new GlassfishOsgiBootstrapClassLoader(installRoot, osgiCL);){
                launcherCL.launchGlassFishServer(cfg.toProperties());
            }
        }
        catch (Throwable t) {
            throw new Error("Could not start the server!", t);
        }
    }

    private static void checkJdkVersion() {
        int version = Runtime.version().feature();
        if (version < 21) {
            LogFacade.BOOTSTRAP_LOGGER.log(Level.SEVERE, "NCLS-BOOTSTRAP-00001", new Object[]{21, version});
            System.exit(1);
        }
    }

    private static Properties initProperties(String[] args) {
        int i;
        Properties map = new Properties();
        if (args.length == 0) {
            return map;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < args.length; ++i) {
            String name = args[i];
            if (name.startsWith("-")) {
                if (i + 1 >= args.length) continue;
                map.put(name, args[++i]);
                continue;
            }
            map.put("default", args[i]);
        }
        if (!GlassFishMain.wasStartedByCLI(map)) {
            for (i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(",,,");
                }
                sb.append(args[i]);
            }
            map.setProperty("-startup-args", sb.toString());
            map.setProperty("-startup-classpath", System.getProperty("java.class.path"));
            map.setProperty("-startup-classname", GlassFishMain.class.getName());
            map.setProperty("-startup-modulepath", System.getProperty("jdk.module.path"));
        }
        return map;
    }

    private static boolean wasStartedByCLI(Properties properties) {
        return properties.getProperty("-asadmin-classpath") != null && properties.getProperty("-asadmin-classname") != null && properties.getProperty("-asadmin-args") != null;
    }

    private static String whichPlatform() {
        String platformSysOption = System.getProperty(GlassFishVariable.OSGI_PLATFORM.getSystemPropertyName());
        if (platformSysOption != null && !platformSysOption.isBlank()) {
            return platformSysOption.trim();
        }
        String platformEnvOption = System.getenv(GlassFishVariable.OSGI_PLATFORM.getEnvName());
        if (platformEnvOption != null && !platformEnvOption.isBlank()) {
            return platformEnvOption.trim();
        }
        return OsgiPlatform.Felix.name();
    }

    private static Path findInstanceRoot(File installRoot, Properties argsAsProps) {
        File instanceDir = GlassFishMain.getInstanceRoot(argsAsProps);
        if (instanceDir == null) {
            instanceDir = GlassFishMain.getDomainRoot(argsAsProps, installRoot);
        }
        GlassFishMain.verifyDomainRoot(instanceDir);
        return instanceDir.toPath();
    }

    private static File getInstanceRoot(Properties argsAsProps) {
        String instanceDir = GlassFishMain.getParam(argsAsProps, "instancedir");
        if (GlassFishMain.isSet(instanceDir)) {
            return new File(instanceDir);
        }
        return null;
    }

    private static File getDomainRoot(Properties argsAsProps, File installRoot) {
        String domainDir = GlassFishMain.getParam(argsAsProps, "domaindir");
        if (GlassFishMain.isSet(domainDir)) {
            return new File(domainDir);
        }
        File defDomainsRoot = GlassFishMain.getDefaultDomainsDir(installRoot);
        String domainName = GlassFishMain.getParam(argsAsProps, "domain");
        if (GlassFishMain.isSet(domainName)) {
            return new File(defDomainsRoot, domainName);
        }
        return GlassFishMain.getDefaultDomain(defDomainsRoot);
    }

    private static File getDefaultDomainsDir(File installRoot) {
        String envKey = GlassFishVariable.DOMAINS_ROOT.getEnvName();
        String sysKey = GlassFishVariable.DOMAINS_ROOT.getSystemPropertyName();
        File domainsDir = new EnvToPropsConverter(installRoot.toPath()).convert(envKey, sysKey);
        if (domainsDir == null) {
            throw new RuntimeException("Neither " + envKey + " env property nor " + sysKey + " system property is set.");
        }
        if (!domainsDir.isDirectory()) {
            throw new RuntimeException(GlassFishVariable.DOMAINS_ROOT.getPropertyName() + "[" + String.valueOf(domainsDir) + "] is NOT a directory.");
        }
        return domainsDir;
    }

    private static File getDefaultDomain(File domainsDir) {
        File[] domains = domainsDir.listFiles(File::isDirectory);
        if (domains == null || domains.length == 0) {
            throw new RuntimeException("no domain directories found under " + String.valueOf(domainsDir));
        }
        if (domains.length > 1) {
            throw new RuntimeException("Multiple domains[" + domains.length + "] found under " + String.valueOf(domainsDir) + " -- you must specify a domain name as -domain <name>");
        }
        return domains[0];
    }

    private static void verifyDomainRoot(File domainRoot) {
        if (domainRoot == null) {
            throw new RuntimeException("Internal Error: The domain dir is null.");
        }
        if (!domainRoot.exists()) {
            throw new RuntimeException("the domain directory does not exist");
        }
        if (!domainRoot.isDirectory()) {
            throw new RuntimeException("the domain directory is not a directory.");
        }
        if (!domainRoot.canWrite()) {
            throw new RuntimeException("the domain directory is not writable.");
        }
        if (!new File(domainRoot, "config").isDirectory()) {
            throw new RuntimeException("the domain directory is corrupt - there is no config subdirectory.");
        }
    }

    private static String getParam(Properties argsAsProps, String name) {
        String val = argsAsProps.getProperty("-" + name);
        if (val == null) {
            val = argsAsProps.getProperty("--" + name);
        }
        return val;
    }

    private static boolean isSet(String s) {
        return s != null && !s.isEmpty();
    }
}

