/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.xmlfilter;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.PolicyConstants;
import com.sun.xml.ws.xmlfilter.FilteringStateMachine;
import com.sun.xml.ws.xmlfilter.Invocation;
import com.sun.xml.ws.xmlfilter.ProcessingStateChange;
import com.sun.xml.ws.xmlfilter.XmlFilteringUtils;
import javax.xml.stream.XMLStreamWriter;

public class PrivateAttributeFilteringStateMachine
implements FilteringStateMachine {
    private static final Logger LOGGER = Logger.getLogger(PrivateAttributeFilteringStateMachine.class);
    private int depth;
    private boolean filteringOn;
    private boolean cmdBufferingOn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingStateChange getStateChange(Invocation invocation, XMLStreamWriter writer) {
        LOGGER.entering(new Object[]{invocation});
        ProcessingStateChange resultingState = ProcessingStateChange.NO_CHANGE;
        try {
            switch (invocation.getMethodType()) {
                case WRITE_START_ELEMENT: {
                    if (this.filteringOn) {
                        ++this.depth;
                        break;
                    }
                    if (this.cmdBufferingOn) {
                        resultingState = ProcessingStateChange.RESTART_BUFFERING;
                        break;
                    }
                    this.cmdBufferingOn = true;
                    resultingState = ProcessingStateChange.START_BUFFERING;
                    break;
                }
                case WRITE_END_ELEMENT: {
                    if (this.filteringOn) {
                        if (this.depth == 0) {
                            this.filteringOn = false;
                            resultingState = ProcessingStateChange.STOP_FILTERING;
                            break;
                        }
                        --this.depth;
                        break;
                    }
                    if (!this.cmdBufferingOn) break;
                    this.cmdBufferingOn = false;
                    resultingState = ProcessingStateChange.STOP_BUFFERING;
                    break;
                }
                case WRITE_ATTRIBUTE: {
                    if (this.filteringOn || !this.cmdBufferingOn || !this.startFiltering(invocation, writer)) break;
                    this.filteringOn = true;
                    this.cmdBufferingOn = false;
                    resultingState = ProcessingStateChange.START_FILTERING;
                    break;
                }
                case CLOSE: {
                    if (this.filteringOn) {
                        this.filteringOn = false;
                        resultingState = ProcessingStateChange.STOP_FILTERING;
                        break;
                    }
                    if (!this.cmdBufferingOn) break;
                    this.cmdBufferingOn = false;
                    resultingState = ProcessingStateChange.STOP_BUFFERING;
                    break;
                }
            }
            ProcessingStateChange processingStateChange = resultingState;
            return processingStateChange;
        }
        finally {
            LOGGER.exiting((Object)resultingState);
        }
    }

    private boolean startFiltering(Invocation invocation, XMLStreamWriter writer) {
        XmlFilteringUtils.AttributeInfo attributeInfo = XmlFilteringUtils.getAttributeNameToWrite(invocation, XmlFilteringUtils.getDefaultNamespaceURI(writer));
        return PolicyConstants.VISIBILITY_ATTRIBUTE.equals(attributeInfo.getName()) && "private".equals(attributeInfo.getValue());
    }
}

