/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.theme.JarTheme;
import com.sun.webui.theme.ThemeConfigurationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public final class ThemeManager {
    public static final String THEME_MANAGER = "com.sun.webui.ThemeManager";
    private static String defaultTheme = null;
    private Locale defaultLocale = null;
    private final HashMap themes = new HashMap();
    private static final boolean DEBUG = false;

    ThemeManager() {
    }

    void addThemeMap(String name, Map themeMap) {
        this.themes.put(name, themeMap);
    }

    public JarTheme getTheme(String name, Locale locale) {
        Map themeMap;
        Object object;
        Object mapObject = this.themes.get(name);
        if (mapObject == null) {
            if (this.themes.isEmpty()) {
                throw new ThemeConfigurationException("CONFIGURATION ERROR: no theme resources library available");
            }
            if (defaultTheme != null) {
                mapObject = this.themes.get(defaultTheme);
                if (mapObject != null) {
                    ThemeManager.log("Using the default theme " + defaultTheme);
                }
            } else {
                ThemeManager.log("WARNING: no default theme name available either, using any theme!");
            }
            if (mapObject == null) {
                mapObject = this.themes.values().iterator().next();
            }
        }
        if ((object = (themeMap = (Map)mapObject).get(locale)) == null) {
            ThemeManager.log("No theme instance found for locale " + locale.getDisplayName());
            if (this.defaultLocale != null) {
                ThemeManager.log("Trying to use the default locale " + this.defaultLocale.getDisplayName());
                object = themeMap.get(this.defaultLocale);
            }
            if (object == null && !themeMap.isEmpty()) {
                ThemeManager.log("Trying to use any theme instance");
                object = themeMap.values().iterator().next();
            }
            if (object == null) {
                throw new ThemeConfigurationException("CONFIGURATION ERROR: no theme resources library available");
            }
        }
        return (JarTheme)object;
    }

    void setDefaultThemeName(String name) {
        if (name != null && name.length() > 0) {
            defaultTheme = name;
        }
        this.checkDefaultThemeName();
    }

    private void setDefaultLocale(Locale newDefaultLocale) {
        this.defaultLocale = newDefaultLocale;
    }

    public String getDefaultThemeName() {
        return defaultTheme;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder().append("ThemeManager for Sun Web Componenents.").append("\nDefault theme is ").append(defaultTheme).append(".\nAvailable themes: ");
        Iterator iterator = this.themes.keySet().iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(" ");
        }
        buffer.append(".\nAvailable locales: ");
        iterator = ((Map)this.themes.get(defaultTheme)).keySet().iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private void checkDefaultThemeName() {
        Iterator keys;
        boolean warn = false;
        if (defaultTheme != null) {
            if (this.themes.containsKey(defaultTheme)) {
                return;
            }
            warn = true;
            ThemeManager.log("WARNING: default theme name " + defaultTheme + " is invalid");
        }
        if ((keys = this.themes.keySet().iterator()).hasNext()) {
            defaultTheme = keys.next().toString();
        }
        if (warn) {
            ThemeManager.log("Using defaultTheme " + defaultTheme + "instead");
        }
    }

    private static void log(String msg) {
        LogUtil.finest(ThemeManager.class.getName() + "::" + msg);
    }
}

