/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.microprofile.config;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.microprofile.config.GlassFishConfigs;
import org.glassfish.microprofile.config.util.LazyProperty;

class GlassFishConfig
implements Config {
    private Supplier<Config> configProducer;
    private volatile Config defaultConfigDelegate;

    public GlassFishConfig(Supplier<Config> configProducer) {
        this.configProducer = configProducer;
    }

    private Config getDefaultConfigDelegate() {
        return this.defaultConfigDelegate;
    }

    private void setDefaultConfigDelegate(Config defaultConfigDelegate) {
        this.defaultConfigDelegate = defaultConfigDelegate;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        return (T)this.getConfigDelegate().getValue(propertyName, propertyType);
    }

    public ConfigValue getConfigValue(String propertyName) {
        return this.getConfigDelegate().getConfigValue(propertyName);
    }

    public <T> List<T> getValues(String propertyName, Class<T> propertyType) {
        return this.getConfigDelegate().getValues(propertyName, propertyType);
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        return this.getConfigDelegate().getOptionalValue(propertyName, propertyType);
    }

    public <T> Optional<List<T>> getOptionalValues(String propertyName, Class<T> propertyType) {
        return this.getConfigDelegate().getOptionalValues(propertyName, propertyType);
    }

    public Iterable<String> getPropertyNames() {
        return this.getConfigDelegate().getPropertyNames();
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.getConfigDelegate().getConfigSources();
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
        return this.getConfigDelegate().getConverter(forType);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.getConfigDelegate().unwrap(type);
    }

    private Config getConfigDelegate() {
        return ((ApplicationRegistry)Globals.get(ApplicationRegistry.class)).getCurrentApplicationInfo().map(currentApplicationInfo -> {
            GlassFishConfigs configs = LazyProperty.getOrCreateAndSet(currentApplicationInfo, GlassFishConfig::getConfigsFromAppInfo, GlassFishConfigs::new, GlassFishConfig::setConfigsToAppInfo);
            return LazyProperty.getOrCreateAndSet(configs, this::getConfigFromConfigs, this.configProducer, this::setConfigToConfigs);
        }).orElseGet(() -> LazyProperty.getOrCreateAndSet(this, GlassFishConfig::getDefaultConfigDelegate, this.configProducer, GlassFishConfig::setDefaultConfigDelegate));
    }

    private static GlassFishConfigs getConfigsFromAppInfo(ApplicationInfo applicationInfo) {
        return (GlassFishConfigs)applicationInfo.getMetaData(GlassFishConfigs.class);
    }

    private static void setConfigsToAppInfo(ApplicationInfo applicationInfo, GlassFishConfigs configs) {
        applicationInfo.addMetaData((Object)configs);
    }

    public Config getConfigFromConfigs(GlassFishConfigs cfgs) {
        return (Config)cfgs.get(this);
    }

    private void setConfigToConfigs(GlassFishConfigs cfgs, Config cfg) {
        cfgs.put(this, cfg);
    }
}

