/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.core;

import jakarta.enterprise.context.RequestScoped;
import jakarta.mvc.Models;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@RequestScoped
public class ModelsImpl
implements Models {
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();

    public Models put(String name, Object model) {
        Objects.requireNonNull(name, "Name must not be null");
        this.map.put(name, model);
        return this;
    }

    public Object get(String name) {
        return this.get(name, Object.class);
    }

    public <T> T get(String name, Class<T> type) {
        Objects.requireNonNull(name, "Name must not be null");
        Objects.requireNonNull(type, "Type must not be null");
        return type.cast(this.map.get(name));
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, Object>(this.map));
    }

    public Iterator<String> iterator() {
        return this.map.keySet().iterator();
    }
}

