/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class WildcardJType
extends AbstractJType {
    private final AbstractJType targetType;
    private final boolean extendsNotSuper;

    public WildcardJType(AbstractJType targetType, boolean extendsNotSuper) {
        this.targetType = targetType;
        this.extendsNotSuper = extendsNotSuper;
    }

    @Override
    boolean equals(AbstractJType other) {
        return other instanceof WildcardJType && this.equals((WildcardJType)other);
    }

    private boolean equals(WildcardJType other) {
        return this.extendsNotSuper == other.extendsNotSuper && this.targetType.equals(other.targetType);
    }

    @Override
    public int hashCode() {
        return this.targetType.hashCode() ^ (this.extendsNotSuper ? 0 : 1);
    }

    @Override
    public String simpleName() {
        return this.targetType.simpleName();
    }

    @Override
    public JType array() {
        throw new UnsupportedOperationException("array of wildcard type not allowed");
    }

    @Override
    public JType wildcardExtends() {
        if (this.extendsNotSuper) {
            return this;
        }
        throw new UnsupportedOperationException("wildcard extends of wildcard super not allowed");
    }

    @Override
    public JType wildcardSuper() {
        if (!this.extendsNotSuper) {
            return this;
        }
        throw new UnsupportedOperationException("wildcard super of wildcard extends not allowed");
    }

    @Override
    void writeDirect(SourceFileWriter sourceFileWriter) throws IOException {
        sourceFileWriter.write(Tokens$.PUNCT.Q);
        AbstractJType targetType = this.getTargetType();
        if (!targetType.equals(JType.OBJECT)) {
            sourceFileWriter.sp();
            sourceFileWriter.write(this.extendsNotSuper ? Tokens$.KW.EXTENDS : Tokens$.KW.SUPER);
            sourceFileWriter.write(targetType);
        }
    }

    @Override
    public String toString() {
        if (this.extendsNotSuper && this.targetType.equals(JType.OBJECT)) {
            return "?";
        }
        return "? " + (this.extendsNotSuper ? "extends " : "super ") + this.targetType;
    }

    AbstractJType getTargetType() {
        return this.targetType;
    }

    boolean isExtendsNotSuper() {
        return this.extendsNotSuper;
    }
}

