/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.glassfish;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.jdke.props.EnvToPropsConverter;

public class ASenvPropertyReader {
    private static final Map<String, String> ENV_TO_SYS_PROPERTY = Map.of(GlassFishVariable.DERBY_ROOT.getEnvName(), GlassFishVariable.DERBY_ROOT.getSystemPropertyName(), GlassFishVariable.IMQ_LIB.getEnvName(), GlassFishVariable.IMQ_LIB.getSystemPropertyName(), GlassFishVariable.IMQ_BIN.getEnvName(), GlassFishVariable.IMQ_BIN.getSystemPropertyName(), GlassFishVariable.CONFIG_ROOT.getEnvName(), GlassFishVariable.CONFIG_ROOT.getSystemPropertyName(), GlassFishVariable.JAVA_ROOT.getEnvName(), GlassFishVariable.JAVA_ROOT.getSystemPropertyName(), GlassFishVariable.DOMAINS_ROOT.getEnvName(), GlassFishVariable.DOMAINS_ROOT.getSystemPropertyName(), GlassFishVariable.NODES_ROOT.getEnvName(), GlassFishVariable.NODES_ROOT.getSystemPropertyName());
    private static final HashMap<File, ASenvMap> propsMap = new HashMap();
    private ASenvMap props;

    public ASenvPropertyReader() {
        this(GFLauncherUtils.getInstallDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASenvPropertyReader(File installDir) {
        HashMap<File, ASenvMap> hashMap = propsMap;
        synchronized (hashMap) {
            installDir = SmartFile.sanitize(installDir);
            this.props = propsMap.get(installDir);
            if (this.props == null) {
                this.props = new ASenvMap(installDir);
                propsMap.put(installDir, this.props);
            }
        }
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set keys = this.props.keySet();
        for (String key : keys) {
            sb.append(key).append("=").append((String)this.props.get(key)).append('\n');
        }
        return sb.toString();
    }

    static class ASenvMap
    extends HashMap<String, String> {
        ASenvMap(File installDir) {
            new EnvToPropsConverter(installDir.toPath()).convert(ENV_TO_SYS_PROPERTY).entrySet().forEach((? super T e) -> this.put((String)e.getKey(), ((File)e.getValue()).getPath()));
            String javaHome = new File(System.getProperty(GlassFishVariable.JAVA_HOME.getSystemPropertyName())).toPath().toString();
            this.putIfAbsent(GlassFishVariable.JAVA_ROOT.getPropertyName(), javaHome);
            this.putIfAbsent(GlassFishVariable.HOST_NAME.getPropertyName(), ASenvMap.getHostname());
            this.putIfAbsent(GlassFishVariable.INSTALL_ROOT.getPropertyName(), installDir.toPath().toString());
            this.putIfAbsent(GlassFishVariable.PRODUCT_ROOT.getPropertyName(), installDir.getParentFile().toPath().toString());
        }

        private static String getHostname() {
            try {
                return NetUtils.getCanonicalHostName();
            }
            catch (Exception ex) {
                return "localhost";
            }
        }
    }
}

