/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.common;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserPrincipal;

public class SubjectUtil {
    public static List<String> getUsernamesFromSubject(Subject subject) {
        ArrayList<String> userList = new ArrayList<String>();
        Set<Principal> princSet = null;
        if (subject != null) {
            princSet = subject.getPrincipals();
            for (Principal p : princSet) {
                if (p == null || !SubjectUtil.isUserPrincipal(p.getClass())) continue;
                String uName = p.getName();
                userList.add(uName);
            }
        }
        return userList;
    }

    public static List<String> getGroupnamesFromSubject(Subject subject) {
        ArrayList<String> groupList = new ArrayList<String>();
        if (subject != null) {
            Set<Group> princSet = subject.getPrincipals(Group.class);
            for (Group g : princSet) {
                String gName = g.getName();
                groupList.add(gName);
            }
        }
        return groupList;
    }

    private static boolean isUserPrincipal(Class<? extends Principal> clazz) {
        return UserPrincipal.class.isAssignableFrom(clazz) || "weblogic.security.principal.WLSUserImpl".equals(clazz.getCanonicalName());
    }
}

