/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data;

import jakarta.data.Direction;
import java.util.Objects;

public record Sort<T>(String property, boolean isAscending, boolean ignoreCase) {
    public Sort {
        Objects.requireNonNull(property, "property is required");
    }

    public boolean isDescending() {
        return !this.isAscending;
    }

    public static <T> Sort<T> of(String property, Direction direction, boolean ignoreCase) {
        Objects.requireNonNull(direction, "direction is required");
        return new Sort<T>(property, Direction.ASC.equals((Object)direction), ignoreCase);
    }

    public static <T> Sort<T> asc(String property) {
        return new Sort<T>(property, true, false);
    }

    public static <T> Sort<T> ascIgnoreCase(String property) {
        return new Sort<T>(property, true, true);
    }

    public static <T> Sort<T> desc(String property) {
        return new Sort<T>(property, false, false);
    }

    public static <T> Sort<T> descIgnoreCase(String property) {
        return new Sort<T>(property, false, true);
    }
}

