/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.IDLNames;
import org.glassfish.rmic.iiop.InterfaceType;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Identifier;

public class SpecialInterfaceType
extends InterfaceType {
    public static SpecialInterfaceType forSpecial(ClassDefinition theClass, ContextStack stack) {
        if (stack.anyErrors()) {
            return null;
        }
        org.glassfish.rmic.tools.java.Type type = theClass.getType();
        Type existing = SpecialInterfaceType.getType(type, stack);
        if (existing != null) {
            if (!(existing instanceof SpecialInterfaceType)) {
                return null;
            }
            return (SpecialInterfaceType)existing;
        }
        if (SpecialInterfaceType.isSpecial(type, theClass, stack)) {
            SpecialInterfaceType result = new SpecialInterfaceType(stack, 0, theClass);
            SpecialInterfaceType.putType(type, (Type)result, stack);
            stack.push(result);
            if (result.initialize(type, stack)) {
                stack.pop(true);
                return result;
            }
            SpecialInterfaceType.removeType(type, stack);
            stack.pop(false);
            return null;
        }
        return null;
    }

    @Override
    public String getTypeDescription() {
        return "Special interface";
    }

    private SpecialInterfaceType(ContextStack stack, int typeCode, ClassDefinition theClass) {
        super(stack, typeCode | 0x20000000 | 0x8000000 | 0x2000000, theClass);
        this.setNames(theClass.getName(), null, null);
    }

    private static boolean isSpecial(org.glassfish.rmic.tools.java.Type type, ClassDefinition theClass, ContextStack stack) {
        if (type.isType(10)) {
            Identifier id = type.getClassName();
            if (id.equals(idRemote)) {
                return true;
            }
            if (id == idJavaIoSerializable) {
                return true;
            }
            if (id == idJavaIoExternalizable) {
                return true;
            }
            if (id == idCorbaObject) {
                return true;
            }
            if (id == idIDLEntity) {
                return true;
            }
            BatchEnvironment env = stack.getEnv();
            try {
                if (env.defCorbaObject.implementedBy(env, theClass.getClassDeclaration())) {
                    return true;
                }
            }
            catch (ClassNotFound e) {
                SpecialInterfaceType.classNotFound(stack, e);
            }
        }
        return false;
    }

    private boolean initialize(org.glassfish.rmic.tools.java.Type type, ContextStack stack) {
        boolean constant;
        int typeCode = 0;
        Identifier id = null;
        String idlName = null;
        String[] idlModuleName = null;
        boolean bl = constant = stack.size() > 0 && stack.getContext().isConstant();
        if (type.isType(10)) {
            id = type.getClassName();
            if (id.equals(idRemote)) {
                typeCode = 524288;
                idlName = "Remote";
                idlModuleName = IDL_JAVA_RMI_MODULE;
            } else if (id == idJavaIoSerializable) {
                typeCode = 1024;
                idlName = "Serializable";
                idlModuleName = IDL_JAVA_IO_MODULE;
            } else if (id == idJavaIoExternalizable) {
                typeCode = 1024;
                idlName = "Externalizable";
                idlModuleName = IDL_JAVA_IO_MODULE;
            } else if (id == idIDLEntity) {
                typeCode = 1024;
                idlName = "IDLEntity";
                idlModuleName = IDL_ORG_OMG_CORBA_PORTABLE_MODULE;
            } else {
                typeCode = 2048;
                if (id == idCorbaObject) {
                    idlName = IDLNames.getTypeName(typeCode, constant);
                    idlModuleName = null;
                } else {
                    try {
                        idlName = IDLNames.getClassOrInterfaceName(id, this.env);
                        idlModuleName = IDLNames.getModuleNames(id, this.isBoxed(), this.env);
                    }
                    catch (Exception e) {
                        SpecialInterfaceType.failedConstraint(7, false, stack, id.toString(), e.getMessage());
                        throw new CompilerError("");
                    }
                }
            }
        }
        if (typeCode == 0) {
            return false;
        }
        this.setTypeCode(typeCode | 0x20000000 | 0x8000000 | 0x2000000);
        if (idlName == null) {
            throw new CompilerError("Not a special type");
        }
        this.setNames(id, idlModuleName, idlName);
        return this.initialize(null, null, null, stack, false);
    }
}

