/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.impl.transport.connection.ConnectionCacheBase;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueueFactory;
import com.sun.corba.ee.spi.transport.connection.Connection;

abstract class ConnectionCacheBlockingBase<C extends Connection>
extends ConnectionCacheBase<C> {
    protected int totalBusy = 0;
    protected int totalIdle = 0;

    ConnectionCacheBlockingBase(String cacheType, int highWaterMark, int numberToReclaim, long ttl) {
        super(cacheType, highWaterMark, numberToReclaim);
        this.reclaimableConnections = ConcurrentQueueFactory.makeConcurrentQueue(ttl);
    }

    @Override
    public synchronized long numberOfConnections() {
        return this.totalIdle + this.totalBusy;
    }

    @Override
    public synchronized long numberOfIdleConnections() {
        return this.totalIdle;
    }

    @Override
    public synchronized long numberOfBusyConnections() {
        return this.totalBusy;
    }

    @Override
    public synchronized long numberOfReclaimableConnections() {
        return this.reclaimableConnections.size();
    }
}

