/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.util.Preconditions;

public final class Iterators {
    private Iterators() {
    }

    public static <T> boolean addAll(Collection<T> target, Iterator<? extends T> iterator) {
        Preconditions.checkArgumentNotNull(target, "target");
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= target.add(iterator.next());
        }
        return modified;
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> iterators) {
        Preconditions.checkArgumentNotNull(iterators, "iterators");
        return new CombinedIterator(iterators);
    }

    public static <T, R> Iterator<R> transform(Iterator<T> iterator, Function<? super T, ? extends R> function) {
        Preconditions.checkArgumentNotNull(iterator, "iterator");
        Preconditions.checkArgumentNotNull(function, "function");
        return new TransformingIterator<T, R>(iterator, function);
    }

    static abstract class IndexIterator<E>
    implements ListIterator<E> {
        private int position;
        private final int size;

        IndexIterator(int size, int position) {
            this.size = size;
            this.position = position;
        }

        IndexIterator(int size) {
            this(size, 0);
        }

        @Override
        public boolean hasNext() {
            return this.position < this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.getElement(this.position++);
        }

        @Override
        public boolean hasPrevious() {
            return this.position > 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.getElement(--this.position);
        }

        @Override
        public int nextIndex() {
            return this.position;
        }

        @Override
        public int previousIndex() {
            return this.position - 1;
        }

        abstract E getElement(int var1);

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    static class TransformingIterator<T, R>
    implements Iterator<R> {
        final Iterator<? extends T> iterator;
        final Function<? super T, ? extends R> function;

        TransformingIterator(Iterator<? extends T> iterator, Function<? super T, ? extends R> function) {
            this.iterator = iterator;
            this.function = function;
        }

        @Override
        public final boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public final R next() {
            return this.function.apply(this.iterator.next());
        }

        @Override
        public final void remove() {
            this.iterator.remove();
        }
    }

    static class CombinedIterator<E>
    implements Iterator<E> {
        private final Iterator<? extends Iterator<? extends E>> iterators;
        private Iterator<? extends E> current;
        private Iterator<? extends E> removeFrom;

        CombinedIterator(Iterator<? extends Iterator<? extends E>> iterators) {
            this.iterators = iterators;
            this.current = Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            boolean currentHasNext;
            while (!(currentHasNext = this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return currentHasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeFrom = this.current;
            return this.current.next();
        }

        @Override
        public void remove() {
            if (this.removeFrom == null) {
                throw new IllegalStateException();
            }
            this.removeFrom.remove();
            this.removeFrom = null;
        }
    }
}

