/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.jaas;

import com.sun.security.auth.login.ConfigFile;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;

public class ExtendedConfigFile
extends ConfigFile {
    private static final Logger logger = Logger.getLogger("enterprise.system.jaspic.security", "com.sun.logging.enterprise.system.jaspic.security.LogStrings");
    private Class<?> moduleClass;

    public static ExtendedConfigFile fromFileName(String configFileName) {
        if (configFileName == null) {
            return new ExtendedConfigFile();
        }
        try {
            return new ExtendedConfigFile(new URI(configFileName));
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
    }

    public ExtendedConfigFile() {
    }

    public ExtendedConfigFile(URI uri) {
        super(uri);
    }

    public ExtendedConfigFile(Class<?> moduleClass) {
        this.moduleClass = moduleClass;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        if (this.moduleClass == null) {
            return super.getAppConfigurationEntry(applicationName);
        }
        AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(this.moduleClass.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.emptyMap());
        return new AppConfigurationEntry[]{appConfigurationEntry};
    }

    public String[] getAppNames(final Class[] authModuleClass) {
        Set nameSet;
        try {
            nameSet = (Set)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Field field = ConfigFile.class.getDeclaredField("configuration");
                    field.setAccessible(true);
                    HashMap map = (HashMap)field.get(ExtendedConfigFile.this);
                    return map.keySet();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new SecurityException(pae.getCause());
        }
        if (authModuleClass != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String[] names;
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        for (String id : names = nameSet.toArray(new String[nameSet.size()])) {
                            boolean hasAuthModule = false;
                            AppConfigurationEntry[] entry = ExtendedConfigFile.this.getAppConfigurationEntry(id);
                            block3: for (int i = 0; i < entry.length && !hasAuthModule; ++i) {
                                String clazz = entry[i].getLoginModuleName();
                                try {
                                    Class<?> c = Class.forName(clazz, true, loader);
                                    for (Class required : authModuleClass) {
                                        if (!required.isAssignableFrom(c)) continue;
                                        hasAuthModule = true;
                                        continue block3;
                                    }
                                    continue;
                                }
                                catch (Throwable t) {
                                    String msg = "skipping unloadable class: " + clazz + " of entry: " + id;
                                    logger.log(Level.WARNING, msg);
                                }
                            }
                            if (hasAuthModule) continue;
                            nameSet.remove(id);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new SecurityException(pae.getCause());
            }
        }
        return nameSet.toArray(new String[nameSet.size()]);
    }
}

