/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.RbCbSelector;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Map;

public final class Checkbox
extends RbCbSelector {
    private int labelLevel = Integer.MIN_VALUE;
    private boolean labelLevelSet = false;

    public Checkbox() {
        this.setMultiple(false);
        this.setRendererType("com.sun.webui.jsf.Checkbox");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.Checkbox";
    }

    public static ArrayList getSelected(String name) {
        Map rm = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        if (name != null) {
            return (ArrayList)rm.get(name);
        }
        return null;
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (!this.isValid()) {
            return;
        }
        String groupName = this.getName();
        if (groupName == null) {
            return;
        }
        Object selected = this.getLocalValue();
        if (!this.getSelectedValue().equals(selected)) {
            return;
        }
        this.addToRequestMap(context, groupName, selected);
    }

    protected void addToRequestMap(FacesContext context, String groupName, Object selected) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ArrayList<Object> selectedCB = (ArrayList<Object>)requestMap.get(groupName);
        if (selectedCB == null) {
            selectedCB = new ArrayList<Object>();
            requestMap.put(groupName, selectedCB);
        }
        if (!selectedCB.contains(selected)) {
            selectedCB.add(selected);
        }
    }

    @Override
    public Object getItems() {
        return super.getItems();
    }

    public boolean isRequired() {
        return super.isRequired();
    }

    public Object getValue() {
        return super.getValue();
    }

    @Override
    public int getLabelLevel() {
        if (this.labelLevelSet) {
            return this.labelLevel;
        }
        ValueExpression vb = this.getValueExpression("labelLevel");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 3;
    }

    @Override
    public void setLabelLevel(int newLabelLevel) {
        this.labelLevel = newLabelLevel;
        this.labelLevelSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.labelLevel = (Integer)values[1];
        this.labelLevelSet = (Boolean)values[2];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.labelLevel, this.labelLevelSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

