/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationInstanceFactoryMetadataMap;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractConfigProcessor
implements ConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String CLASS_METADATA_MAP_KEY_SUFFIX = ".METADATA";

    private ApplicationInstanceFactoryMetadataMap<String, Object> getClassMetadataMap(ServletContext servletContext) {
        ApplicationInstanceFactoryMetadataMap classMetadataMap = (ApplicationInstanceFactoryMetadataMap)servletContext.getAttribute(this.getClassMetadataMapKey());
        if (classMetadataMap == null) {
            classMetadataMap = new ApplicationInstanceFactoryMetadataMap((Map<String, Object>)new ConcurrentHashMap<String, Object>());
            servletContext.setAttribute(this.getClassMetadataMapKey(), classMetadataMap);
        }
        return classMetadataMap;
    }

    @Override
    public void initializeClassMetadataMap(ServletContext servletContext, FacesContext facesContext) {
        this.getClassMetadataMap(servletContext);
    }

    protected String getClassMetadataMapKey() {
        return this.getClass().getName() + CLASS_METADATA_MAP_KEY_SUFFIX;
    }

    @Override
    public void destroy(ServletContext sc, FacesContext facesContext) {
    }

    protected Application getApplication() {
        return ((ApplicationFactory)FactoryFinder.getFactory("jakarta.faces.application.ApplicationFactory")).getApplication();
    }

    protected String getNodeText(Node node) {
        String res = null;
        if (node != null && (res = node.getTextContent()) != null) {
            res = res.trim();
        }
        return res != null && res.length() != 0 ? res : null;
    }

    protected Map<String, String> getTextMap(List<Node> list) {
        if (list != null && !list.isEmpty()) {
            int len = list.size();
            HashMap<String, String> names = new HashMap<String, String>(len, 1.0f);
            for (int i = 0; i < len; ++i) {
                Node node = list.get(i);
                String textValue = this.getNodeText(node);
                if (textValue == null) continue;
                if (node.hasAttributes()) {
                    NamedNodeMap attributes = node.getAttributes();
                    String lang = this.getNodeText(attributes.getNamedItem("lang"));
                    if (lang == null) {
                        lang = this.getNodeText(attributes.getNamedItem("xml:lang"));
                    }
                    if (lang != null) {
                        names.put(lang, textValue);
                        continue;
                    }
                    names.put("DEFAULT", textValue);
                    continue;
                }
                names.put("DEFAULT", textValue);
            }
            return names;
        }
        return null;
    }

    protected Class<?> findRootType(ServletContext sc, FacesContext facesContext, String source, Node sourceNode, Class<?>[] ctorArguments) {
        try {
            Class<?> sourceClass = this.loadClass(sc, facesContext, source, this, null);
            for (Class<?> ctorArg : ctorArguments) {
                if (ReflectionUtils.lookupConstructor(sourceClass, ctorArg) == null) continue;
                return ctorArg;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to find class ''{0}''", source), sourceNode), cnfe);
        }
        return null;
    }

    protected Object createInstance(ServletContext sc, FacesContext facesContext, String className, Node source) {
        return this.createInstance(sc, facesContext, className, null, null, source);
    }

    protected Object createInstance(ServletContext sc, FacesContext facesContext, String className, Class<?> rootType, Object root, Node source) {
        boolean[] didPerformInjection = new boolean[]{false};
        Object result = this.createInstance(sc, facesContext, className, rootType, root, source, true, didPerformInjection);
        return result;
    }

    protected Object createInstance(ServletContext sc, FacesContext facesContext, String className, Class<?> rootType, Object root, Node source, boolean performInjection, boolean[] didPerformInjection) {
        Object returnObject;
        block12: {
            returnObject = null;
            if (className != null) {
                try {
                    ApplicationInstanceFactoryMetadataMap<String, Object> classMetadataMap;
                    Constructor<?> construct;
                    Class<?> clazz = this.loadClass(sc, facesContext, className, returnObject, null);
                    if (clazz == null) break block12;
                    if (returnObject == null && rootType != null && root != null && (construct = ReflectionUtils.lookupConstructor(clazz, rootType)) != null) {
                        returnObject = construct.newInstance(root);
                    }
                    if (clazz != null && returnObject == null) {
                        returnObject = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    if (!(classMetadataMap = this.getClassMetadataMap(sc)).hasAnnotations(className) || !performInjection) break block12;
                    InjectionProvider injectionProvider = (InjectionProvider)facesContext.getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY);
                    try {
                        injectionProvider.inject(returnObject);
                    }
                    catch (InjectionProviderException ex) {
                        LOGGER.log(Level.SEVERE, "Unable to inject instance" + className, ex);
                        throw new FacesException(ex);
                    }
                    try {
                        injectionProvider.invokePostConstruct(returnObject);
                    }
                    catch (InjectionProviderException ex) {
                        LOGGER.log(Level.SEVERE, "Unable to invoke @PostConstruct annotated method on instance " + className, ex);
                        throw new FacesException(ex);
                    }
                    didPerformInjection[0] = true;
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to find class ''{0}''", className), source), cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is missing a runtime dependency: {1}", className, ncdfe.toString()), source), ncdfe);
                }
                catch (ClassCastException cce) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is not an instance of ''{1}''", className, rootType), source), cce);
                }
                catch (FacesException | IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", className, e.toString()), source), e);
                }
            }
        }
        return returnObject;
    }

    protected void destroyInstance(ServletContext sc, FacesContext facesContext, String className, Object instance) {
        InjectionProvider injectionProvider;
        ApplicationInstanceFactoryMetadataMap<String, Object> classMetadataMap;
        if (instance != null && (classMetadataMap = this.getClassMetadataMap(sc)).hasAnnotations(className) && (injectionProvider = (InjectionProvider)facesContext.getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY)) != null) {
            try {
                injectionProvider.invokePreDestroy(instance);
            }
            catch (InjectionProviderException ex) {
                LOGGER.log(Level.SEVERE, "Unable to invoke @PreDestroy annotated method on instance " + className, ex);
                throw new FacesException(ex);
            }
        }
    }

    protected Class<?> loadClass(ServletContext sc, FacesContext facesContext, String className, Object fallback, Class<?> expectedType) throws ClassNotFoundException {
        ApplicationInstanceFactoryMetadataMap<String, Object> classMetadataMap = this.getClassMetadataMap(sc);
        Class clazz = (Class)classMetadataMap.get(className);
        if (clazz == null) {
            try {
                clazz = Util.loadClass(className, fallback);
                if (!this.isDevModeEnabled(sc, facesContext)) {
                    classMetadataMap.put(className, clazz);
                } else {
                    classMetadataMap.scanForAnnotations(className, clazz);
                }
            }
            catch (Exception e) {
                throw new FacesException(e.getMessage(), e);
            }
        }
        if (expectedType != null && !expectedType.isAssignableFrom(clazz)) {
            throw new ClassCastException();
        }
        return clazz;
    }

    protected void processAnnotations(FacesContext ctx, Class<? extends Annotation> annotationType) {
        ApplicationAssociate.getInstance(ctx.getExternalContext()).getAnnotationManager().applyConfigAnnotations(ctx, annotationType, ConfigManager.getAnnotatedClasses(ctx).get(annotationType));
    }

    private String buildMessage(String cause, Node source) {
        return MessageFormat.format("\n  Source Document: {0}\n  Cause: {1}", source.getOwnerDocument().getDocumentURI(), cause);
    }

    private boolean isDevModeEnabled(ServletContext sc, FacesContext facesContext) {
        return this.getProjectStage(sc, facesContext).equals((Object)ProjectStage.Development);
    }

    private ProjectStage getProjectStage(ServletContext sc, FacesContext facesContext) {
        String projectStageKey = AbstractConfigProcessor.class.getName() + ".PROJECTSTAGE";
        ProjectStage projectStage = (ProjectStage)((Object)sc.getAttribute(projectStageKey));
        if (projectStage == null) {
            block9: {
                WebConfiguration webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
                String value = webConfig.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ProjectStage);
                if (value != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "ProjectStage configured via JNDI: {0}", value);
                    }
                } else {
                    value = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.JakartaFacesProjectStage);
                    if (value != null && LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "ProjectStage configured via servlet context init parameter: {0}", value);
                    }
                }
                if (value != null) {
                    try {
                        projectStage = ProjectStage.valueOf(value);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!LOGGER.isLoggable(Level.INFO)) break block9;
                        LOGGER.log(Level.INFO, "Unable to discern ProjectStage for value {0}.", value);
                    }
                }
            }
            if (projectStage == null) {
                projectStage = ProjectStage.Production;
            }
            sc.setAttribute(projectStageKey, (Object)projectStage);
        }
        return projectStage;
    }
}

