/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KDF;
import com.jcraft.jsch.asn1.ASN1;
import com.jcraft.jsch.asn1.ASN1Exception;

public class SCrypt
implements KDF {
    private Class<?> ignore;
    private byte[] salt;
    private int cost;
    private int blocksize;
    private int parallel;

    @Override
    public void initWithASN1(byte[] asn1) throws Exception {
        try {
            this.ignore = org.bouncycastle.crypto.generators.SCrypt.class;
            ASN1 content = new ASN1(asn1);
            if (!content.isSEQUENCE()) {
                throw new ASN1Exception();
            }
            ASN1[] contents = content.getContents();
            if (contents.length < 4 || contents.length > 5) {
                throw new ASN1Exception();
            }
            if (!contents[0].isOCTETSTRING()) {
                throw new ASN1Exception();
            }
            if (!contents[1].isINTEGER()) {
                throw new ASN1Exception();
            }
            if (!contents[2].isINTEGER()) {
                throw new ASN1Exception();
            }
            if (!contents[3].isINTEGER()) {
                throw new ASN1Exception();
            }
            if (contents.length > 4 && !contents[4].isINTEGER()) {
                throw new ASN1Exception();
            }
            this.salt = contents[0].getContent();
            this.cost = ASN1.parseASN1IntegerAsInt(contents[1].getContent());
            this.blocksize = ASN1.parseASN1IntegerAsInt(contents[2].getContent());
            this.parallel = ASN1.parseASN1IntegerAsInt(contents[3].getContent());
        }
        catch (Exception | LinkageError e) {
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            if (e instanceof ASN1Exception || e instanceof ArithmeticException) {
                throw new JSchException("invalid ASN1", e);
            }
            throw new JSchException("scrypt unavailable", e);
        }
    }

    @Override
    public byte[] getKey(byte[] pass, int size) {
        return org.bouncycastle.crypto.generators.SCrypt.generate((byte[])pass, (byte[])this.salt, (int)this.cost, (int)this.blocksize, (int)this.parallel, (int)size);
    }
}

