/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.BinaryRepresentationWriter;
import org.glassfish.grizzly.http2.hpack.HeaderTable;
import org.glassfish.grizzly.http2.hpack.IntegerWriter;

final class SizeUpdateWriter
implements BinaryRepresentationWriter {
    private final IntegerWriter intWriter = new IntegerWriter();
    private int maxSize;
    private boolean tableUpdated;

    SizeUpdateWriter() {
    }

    SizeUpdateWriter maxHeaderTableSize(int size) {
        this.intWriter.configure(size, 5, 32);
        this.maxSize = size;
        return this;
    }

    @Override
    public boolean write(HeaderTable table, Buffer destination) {
        if (!this.tableUpdated) {
            table.setMaxSize(this.maxSize);
            this.tableUpdated = true;
        }
        return this.intWriter.write(destination);
    }

    @Override
    public BinaryRepresentationWriter reset() {
        this.intWriter.reset();
        this.maxSize = -1;
        this.tableUpdated = false;
        return this;
    }
}

