/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationSignal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GroupLeadershipNotificationSignalImpl
implements GroupLeadershipNotificationSignal {
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";
    private GMSContext ctx;
    private final String memberToken;
    private final String groupName;
    private final long startTime;
    private final List<GMSMember> previousView;
    private final List<GMSMember> currentView;
    private final List<String> currentCoreMembers;
    private final List<String> allCurrentMembers;

    public GroupLeadershipNotificationSignalImpl(String memberToken, List<GMSMember> previousView, List<GMSMember> currentView, List<String> currentCoreMembers, List<String> allCurrentMembers, String groupName, long startTime) {
        this.memberToken = memberToken;
        this.previousView = previousView;
        this.currentView = currentView;
        this.currentCoreMembers = currentCoreMembers;
        this.allCurrentMembers = allCurrentMembers;
        this.groupName = groupName;
        this.startTime = startTime;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
    }

    GroupLeadershipNotificationSignalImpl(GroupLeadershipNotificationSignal signal) {
        this(signal.getMemberToken(), signal.getPreviousView(), signal.getCurrentView(), signal.getCurrentCoreMembers(), signal.getAllCurrentMembers(), signal.getGroupName(), signal.getStartTime());
    }

    public void acquire() throws SignalAcquireException {
    }

    public void release() throws SignalReleaseException {
    }

    public String getMemberToken() {
        return this.memberToken;
    }

    public Map<Serializable, Serializable> getMemberDetails() {
        DistributedStateCache dsc;
        HashMap<Serializable, Serializable> ret = new HashMap();
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        if ((dsc = this.ctx.getDistributedStateCache()) != null) {
            ret = dsc.getFromCacheForPattern(MEMBER_DETAILS, this.memberToken);
        } else {
            logger.log(Level.WARNING, "no.instance.dsc", new Object[]{this.memberToken});
        }
        return ret;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public List<GMSMember> getPreviousView() {
        return this.previousView;
    }

    public List<GMSMember> getCurrentView() {
        return this.currentView;
    }

    public List<String> getCurrentCoreMembers() {
        return this.currentCoreMembers;
    }

    public List<String> getAllCurrentMembers() {
        return this.allCurrentMembers;
    }
}

