/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.virtual.LoomishExecutors;
import org.glassfish.tyrus.core.virtual.VirtualThreadSupport;

final class VirtualThreadUtil {
    private static final boolean USE_VIRTUAL_THREADS_BY_DEFAULT = false;

    private VirtualThreadUtil() {
        throw new IllegalStateException();
    }

    public static LoomishExecutors withConfig(Map<String, Object> properties, ThreadFactory defaultFactory, Boolean useVirtualByDefault) {
        Object threadFactory;
        ThreadFactory tfThreadFactory = null;
        boolean useVirtualThreads = VirtualThreadUtil.useVirtualThreads(properties, useVirtualByDefault);
        if (properties != null && ThreadFactory.class.isInstance(threadFactory = properties.get(TyrusWebSocketEngine.THREAD_FACTORY))) {
            tfThreadFactory = (ThreadFactory)threadFactory;
        }
        return tfThreadFactory == null ? VirtualThreadSupport.allowVirtual(useVirtualThreads, defaultFactory) : VirtualThreadSupport.allowVirtual(useVirtualThreads, tfThreadFactory);
    }

    private static boolean useVirtualThreads(Map<String, Object> properties, Boolean useByDefault) {
        boolean bUseVirtualThreads;
        boolean bl = bUseVirtualThreads = useByDefault == null ? false : useByDefault;
        if (properties != null) {
            Object useVirtualThread = properties.get("org.glassfish.tyrus.executorServiceUseVirtualThreads");
            if (Boolean.class.isInstance(useVirtualThread)) {
                bUseVirtualThreads = (Boolean)useVirtualThread;
            }
            if (String.class.isInstance(useVirtualThread)) {
                bUseVirtualThreads = Boolean.parseBoolean(useVirtualThread.toString());
            }
        }
        return bUseVirtualThreads;
    }
}

