/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import org.glassfish.rmic.BatchEnvironment;
import org.glassfish.rmic.IndentingWriter;
import org.glassfish.rmic.Main;
import org.glassfish.rmic.iiop.CompoundType;
import org.glassfish.rmic.iiop.Constants;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.IDLNames;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassFile;
import org.glassfish.rmic.tools.java.ClassPath;
import org.glassfish.rmic.tools.java.Identifier;

public abstract class Generator
implements org.glassfish.rmic.Generator,
Constants {
    private boolean alwaysGenerate = false;
    private org.glassfish.rmic.iiop.BatchEnvironment env = null;
    private boolean trace = false;

    @Override
    public boolean parseArgs(String[] argv, Main main) {
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i] == null) continue;
            if (argv[i].equalsIgnoreCase("-always") || argv[i].equalsIgnoreCase("-alwaysGenerate")) {
                this.alwaysGenerate = true;
                argv[i] = null;
                continue;
            }
            if (!argv[i].equalsIgnoreCase("-xtrace")) continue;
            this.trace = true;
            argv[i] = null;
        }
        return true;
    }

    protected abstract boolean parseNonConforming(ContextStack var1);

    protected abstract CompoundType getTopType(ClassDefinition var1, ContextStack var2);

    protected abstract OutputType[] getOutputTypesFor(CompoundType var1, HashSet<Type> var2);

    protected abstract String getFileNameExtensionFor(OutputType var1);

    protected abstract void writeOutputFor(OutputType var1, HashSet<Type> var2, IndentingWriter var3) throws IOException;

    protected abstract boolean requireNewInstance();

    private boolean requiresGeneration(File target, Type theType) {
        boolean result = this.alwaysGenerate;
        if (!result) {
            String className;
            ClassPath path = this.env.getClassPath();
            ClassFile baseFile = path.getFile((className = theType.getQualifiedName().replace('.', File.separatorChar)) + ".source");
            if (baseFile == null) {
                baseFile = path.getFile(className + ".class");
            }
            if (baseFile != null) {
                long targetFileMod;
                long baseFileMod = baseFile.lastModified();
                String targetName = IDLNames.replace(target.getName(), ".java", ".class");
                String parentPath = target.getParent();
                File targetFile = new File(parentPath, targetName);
                result = targetFile.exists() ? (targetFileMod = targetFile.lastModified()) < baseFileMod : true;
            } else {
                result = true;
            }
        }
        return result;
    }

    private Generator newInstance() {
        Generator result = null;
        try {
            result = (Generator)this.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    Generator() {
    }

    @Override
    public void generate(BatchEnvironment env, File destDir, ClassDefinition cdef) {
        this.env = (org.glassfish.rmic.iiop.BatchEnvironment)env;
        ContextStack contextStack = new ContextStack(this.env);
        contextStack.setTrace(this.trace);
        this.env.setParseNonConforming(this.parseNonConforming(contextStack));
        CompoundType topType = this.getTopType(cdef, contextStack);
        if (topType != null) {
            Generator generator = this;
            if (this.requireNewInstance()) {
                generator = this.newInstance();
            }
            generator.generateOutputFiles(topType, this.env, destDir);
        }
    }

    private void generateOutputFiles(CompoundType topType, org.glassfish.rmic.iiop.BatchEnvironment env, File destDir) {
        OutputType[] types;
        HashSet<Type> alreadyChecked = env.alreadyChecked;
        for (OutputType type : types = this.getOutputTypesFor(topType, alreadyChecked)) {
            File file = this.getFileFor(type, destDir);
            if (!this.requiresGeneration(file, type.getType())) {
                if (!env.verbose()) continue;
                env.output(Main.getText("rmic.previously.generated", file.getPath()));
                continue;
            }
            try {
                IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)), 4, Integer.MAX_VALUE);
                long startTime = !env.verbose() ? 0L : System.currentTimeMillis();
                this.writeOutputFor(type, alreadyChecked, out);
                out.close();
                if (env.verbose()) {
                    long duration = System.currentTimeMillis() - startTime;
                    env.output(Main.getText("rmic.generated", file.getPath(), Long.toString(duration)));
                }
                this.postProcessFile(env, file);
            }
            catch (IOException e) {
                env.error(0L, "cant.write", file.toString());
                return;
            }
        }
    }

    protected void postProcessFile(org.glassfish.rmic.iiop.BatchEnvironment env, File file) throws FileNotFoundException {
    }

    private File getFileFor(OutputType outputType, File destinationDir) {
        Identifier id = this.getOutputId(outputType);
        File packageDir = this.getOutputDirectory(destinationDir, id, this.env);
        String classFileName = outputType.getName() + this.getFileNameExtensionFor(outputType);
        return new File(packageDir, classFileName);
    }

    protected abstract File getOutputDirectory(File var1, Identifier var2, org.glassfish.rmic.iiop.BatchEnvironment var3);

    protected Identifier getOutputId(OutputType outputType) {
        return outputType.getType().getIdentifier();
    }

    public class OutputType {
        private String name;
        private Type type;

        OutputType(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }
}

