/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.converter;

import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.util.ThemeUtilities;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;

public final class DateConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1580936705838582740L;
    private static final String INVALID_DATE_ID = "DateConverter.invalidDate";

    public String getAsString(FacesContext context, UIComponent component, Object o) throws ConverterException {
        try {
            return DateConverter.getDateManager(component).getDateFormat().format((Date)o);
        }
        catch (Exception ex) {
            throw new ConverterException((Throwable)ex);
        }
    }

    public Object getAsObject(FacesContext context, UIComponent component, String s) throws ConverterException {
        if (s.length() == 0) {
            return null;
        }
        DateFormat df = DateConverter.getDateManager(component).getDateFormat();
        boolean saveLenient = df.isLenient();
        df.setLenient(false);
        try {
            Date date;
            Date date2 = date = df.parse(s);
            return date2;
        }
        catch (ParseException ex) {
            FacesMessage facesMessage = null;
            try {
                String message = ThemeUtilities.getTheme(context).getMessage(INVALID_DATE_ID);
                MessageFormat mf = new MessageFormat(message, context.getViewRoot().getLocale());
                String example = DateConverter.getDateManager(component).getDateFormat().format(new Date());
                Object[] params = new Object[]{s, example};
                facesMessage = new FacesMessage(mf.format(params));
            }
            catch (Exception e) {
                throw new ConverterException((Throwable)ex);
            }
            throw new ConverterException(facesMessage);
        }
        finally {
            df.setLenient(saveLenient);
        }
    }

    private static DateManager getDateManager(UIComponent component) {
        DateManager dateManager = null;
        if (component instanceof DateManager) {
            dateManager = (DateManager)component;
        } else if (component.getParent() instanceof DateManager) {
            dateManager = (DateManager)component.getParent();
        }
        if (dateManager == null) {
            throw new RuntimeException("The DateConverter can only be used with components which implement DateManager");
        }
        return dateManager;
    }
}

