/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.provider;

import com.sun.ts.tests.jacc.provider.TSLogger;
import com.sun.ts.tests.jacc.provider.TSPolicy;
import com.sun.ts.tests.jacc.provider.TSPolicyConfigurationImpl;
import java.security.Policy;
import java.util.logging.Level;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

public class TSPolicyConfigurationFactoryImpl
extends PolicyConfigurationFactory {
    private static TSLogger lgr = null;
    private static String FACTORY_NAME = "vendor.javax.security.jacc.PolicyConfigurationFactory.provider";
    private static PolicyConfigurationFactory pcFactory;
    private static TSPolicyConfigurationImpl policyConfiguration;
    private static ClassLoader classLoader;

    public TSPolicyConfigurationFactoryImpl() throws PolicyContextException {
        try {
            pcFactory = TSPolicyConfigurationFactoryImpl.getPolicyConfigurationFactory();
        }
        catch (PolicyContextException pce) {
            if (lgr != null) {
                lgr.severe("Failed to get PolicyConfigurationFactory");
            }
            throw new PolicyContextException((Throwable)pce);
        }
    }

    public PolicyConfiguration getPolicyConfiguration(String contextId, boolean remove) throws PolicyContextException {
        TSPolicyConfigurationImpl polConf = null;
        if (lgr.isLoggable(Level.FINER)) {
            lgr.entering("PolicyConfigurationFactoryImpl", "getPolicyConfiguration");
        }
        polConf = new TSPolicyConfigurationImpl(contextId, remove, lgr);
        lgr.log(Level.INFO, "PolicyConfigurationFactory.getPolicyConfiguration() invoked");
        lgr.log(Level.FINER, "Getting PolicyConfiguration object with id = " + contextId);
        policyConfiguration = polConf;
        return polConf;
    }

    public static PolicyConfigurationFactory getPolicyConfigurationFactory() throws PolicyContextException {
        TSPolicyConfigurationFactoryImpl.getTSLogger();
        if (pcFactory != null) {
            return pcFactory;
        }
        String classname = System.getProperty(FACTORY_NAME);
        if (classname == null) {
            lgr.severe("factory.name.notset");
            throw new PolicyContextException("PolicyConfigurationFactory name not set!");
        }
        try {
            classLoader = TSPolicyConfigurationFactoryImpl.class.getClassLoader();
            Class<?> clazz = classLoader.loadClass(classname);
            pcFactory = (PolicyConfigurationFactory)clazz.newInstance();
            if (pcFactory != null) {
                lgr.log(Level.INFO, "PolicyConfigurationFactory instantiated");
            }
        }
        catch (Exception e) {
            lgr.log(Level.SEVERE, "factory.instantiation.error", e);
            throw new PolicyContextException((Throwable)e);
        }
        return pcFactory;
    }

    public boolean inService(String contextId) throws PolicyContextException {
        if (lgr.isLoggable(Level.FINER)) {
            lgr.entering("PolicyConfigurationFactoryImpl", "inService");
        }
        lgr.log(Level.INFO, "PolicyConfigurationFactory.inService() invoked");
        lgr.log(Level.FINER, "PolicyConfiguration.inService() invoked for context id = " + contextId);
        if (lgr.isLoggable(Level.FINER)) {
            lgr.entering("PolicyConfigurationFactoryImpl", "getPolicyConfiguration");
        }
        return pcFactory.inService(contextId);
    }

    private static void getTSLogger() {
        if (lgr != null) {
            return;
        }
        TSPolicy tsPolicy = (TSPolicy)Policy.getPolicy();
        lgr = tsPolicy.getTSLogger();
    }

    static {
        policyConfiguration = null;
        classLoader = null;
    }
}

