/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.configuration.xml;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_config_xml_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_config_xml_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_config_xml_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/xmltrue/XmlJspTest.xsp")), "xmltrue/XmlJspTest.xsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/xmlfalse/NonXmlTest.jsp")), "xmlfalse/NonXmlTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/unspec/NonXmlTest.jsp")), "unspec/NonXmlTest.jsp");
        return archive;
    }

    @Test
    public void jspConfigurationIsXmlUnspecTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_xml_web/unspec/NonXmlTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void jspConfigurationIsXmlFalseTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_xml_web/xmlfalse/NonXmlTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void jspConfigurationIsXmlTrueTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_xml_web/xmltrue/XmlJspTest.xsp HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "jsp:page|directive");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }
}

