/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.application.closing;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;

@ServerEndpoint(value="/closesession")
public class WSCCloseSessionServer {
    static int lastCloseCode = 0;
    static final String[] MESSAGES = new String[]{"idle", "lastcode"};

    @OnMessage
    public String onMessage(String msg, Session session) {
        if (MESSAGES[0].equals(msg)) {
            WSCCloseSessionServer.setLastCloseCode(0);
            session.setMaxIdleTimeout(1L);
        } else if (MESSAGES[1].equals(msg)) {
            msg = WSCCloseSessionServer.getLastCloseCode();
        }
        return msg;
    }

    @OnError
    public void onError(Session session, Throwable thr) throws IOException {
        thr.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)thr);
        session.getBasicRemote().sendText(message);
    }

    @OnClose
    public void onClose(CloseReason reason) {
        int lastCloseCode = reason.getCloseCode().getCode();
        WSCCloseSessionServer.setLastCloseCode(lastCloseCode);
    }

    private static String getLastCloseCode() {
        return String.valueOf(lastCloseCode);
    }

    private static void setLastCloseCode(int lastCloseCode) {
        WSCCloseSessionServer.lastCloseCode = lastCloseCode;
    }
}

