/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.fx.ide.model.IFXCollectionProperty;
import org.eclipse.fx.ide.model.IFXPrimitiveProperty;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.fx.ide.model.internal.FXClass;
import org.eclipse.fx.ide.model.internal.FXCollectionProperty;
import org.eclipse.fx.ide.model.internal.FXEnumProperty;
import org.eclipse.fx.ide.model.internal.FXEventHandlerProperty;
import org.eclipse.fx.ide.model.internal.FXMapProperty;
import org.eclipse.fx.ide.model.internal.FXObjectPoperty;
import org.eclipse.fx.ide.model.internal.FXPrimitiveProperty;
import org.eclipse.fx.ide.model.internal.FXProperty;
import org.eclipse.fx.ide.model.internal.utils.Util;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class PropertiesUtil {
    public static Map<String, IFXProperty> resolveProperties(FXClass fxClass) throws JavaModelException {
        Object name;
        IMethod m;
        int n;
        int n2;
        IMethod[] iMethodArray;
        HashMap<String, IFXProperty> rv = new HashMap<String, IFXProperty>();
        if ("java.lang.Object".equals(fxClass.getFQN())) {
            return rv;
        }
        HashMap<Object, IMethod> beanProperties = new HashMap<Object, IMethod>();
        HashMap<String, IMethod> builderProperties = new HashMap<String, IMethod>();
        String builder = fxClass.getType().getFullyQualifiedName() + "Builder";
        IType builderType = fxClass.getJavaProject().findType(builder);
        if (builderType != null) {
            iMethodArray = builderType.getMethods();
            n2 = iMethodArray.length;
            n = 0;
            while (n < n2) {
                String param;
                m = iMethodArray[n];
                if (Flags.isPublic((int)m.getFlags()) && !Flags.isStatic((int)m.getFlags()) && !"build".equals(name = m.getElementName()) && !"applyTo".equals(name) && m.getParameterNames().length == 1 && Signature.getArrayCount((String)(param = m.getParameterTypes()[0])) == 0) {
                    builderProperties.put((String)name, m);
                }
                ++n;
            }
        }
        iMethodArray = fxClass.getType().getMethods();
        n2 = iMethodArray.length;
        n = 0;
        while (n < n2) {
            m = iMethodArray[n];
            if (!(!Flags.isPublic((int)m.getFlags()) || Flags.isStatic((int)m.getFlags()) || ((String)(name = m.getElementName())).startsWith("getImpl") || ((String)name).startsWith("isImpl") || ((String)name).startsWith("setImpl") || ((String)name).contains("Unmodifiable"))) {
                if (((String)name).startsWith("get") || ((String)name).startsWith("is")) {
                    name = ((String)name).startsWith("get") ? ((String)name).substring(3) : ((String)name).substring(2);
                    if (!beanProperties.containsKey(name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1))) {
                        beanProperties.put(name, m);
                    }
                } else if (m.getElementName().startsWith("set") && m.getParameters().length == 1) {
                    name = ((String)name).substring(3);
                    name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
                    beanProperties.put(name, m);
                }
            }
            ++n;
        }
        for (Map.Entry e : beanProperties.entrySet()) {
            FXProperty p = PropertiesUtil.getProperty(fxClass, (String)e.getKey(), (IMethod)e.getValue());
            if (p == null) continue;
            rv.put((String)e.getKey(), p);
        }
        for (Map.Entry e : builderProperties.entrySet()) {
            IFXProperty p = (IFXProperty)rv.get(e.getKey());
            if (p == null || p instanceof IFXCollectionProperty || p.isSetable() || (p = PropertiesUtil.getProperty(fxClass, (String)e.getKey(), (IMethod)e.getValue())) == null) continue;
            rv.put((String)e.getKey(), p);
        }
        return rv;
    }

    private static FXProperty getProperty(FXClass fxClass, String name, IMethod m) throws JavaModelException {
        FXProperty p = null;
        String signature = m.getElementName().startsWith("get") || m.getElementName().startsWith("is") ? m.getReturnType() : m.getParameterTypes()[0];
        String genericType = Signature.toString((String)signature);
        if (FXPrimitiveProperty.isPrimitive(genericType)) {
            p = new FXPrimitiveProperty(fxClass, name, m, IFXPrimitiveProperty.Type.parseType(genericType), false);
        } else {
            String erasedFQNType = Util.getFQNType((IType)m.getParent(), Signature.getTypeErasure((String)genericType));
            if (erasedFQNType != null) {
                p = FXEventHandlerProperty.isEventHandler(fxClass.getJavaProject(), erasedFQNType) ? new FXEventHandlerProperty(fxClass, name, (IJavaElement)m, false) : (FXCollectionProperty.isList(fxClass.getJavaProject(), erasedFQNType) ? new FXCollectionProperty(fxClass, name, m, erasedFQNType, genericType, false) : (FXMapProperty.isMap(fxClass.getJavaProject(), erasedFQNType) ? new FXMapProperty(fxClass, name, (IJavaElement)m, false) : (FXEnumProperty.isEnum(fxClass.getJavaProject(), erasedFQNType) ? new FXEnumProperty(fxClass, name, (IJavaElement)m, erasedFQNType, false) : new FXObjectPoperty(fxClass, name, (IJavaElement)m, erasedFQNType, false))));
            }
        }
        return p;
    }

    public static Map<String, IFXProperty> resolveStaticProperties(FXClass fxClass) throws JavaModelException {
        HashMap<String, IFXProperty> rv = new HashMap<String, IFXProperty>();
        if ("java.lang.Object".equals(fxClass.getFQN())) {
            return rv;
        }
        IMethod[] iMethodArray = fxClass.getType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object name;
            IMethod m = iMethodArray[n2];
            if (Flags.isPublic((int)m.getFlags()) && Flags.isStatic((int)m.getFlags()) && !((String)(name = m.getElementName())).startsWith("setImpl") && ((String)name).startsWith("set") && m.getParameterTypes().length == 2) {
                name = ((String)name).substring(3);
                name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
                FXProperty p = null;
                String signature = m.getParameterTypes()[1];
                String genericType = Signature.toString((String)signature);
                if (FXPrimitiveProperty.isPrimitive(genericType)) {
                    p = new FXPrimitiveProperty(fxClass, (String)name, m, IFXPrimitiveProperty.Type.parseType(genericType), true);
                } else {
                    String erasedFQNType = Util.getFQNType((IType)m.getParent(), Signature.getTypeErasure((String)genericType));
                    if (erasedFQNType != null) {
                        p = FXEnumProperty.isEnum(fxClass.getJavaProject(), erasedFQNType) ? new FXEnumProperty(fxClass, (String)name, (IJavaElement)m, erasedFQNType, true) : new FXObjectPoperty(fxClass, (String)name, (IJavaElement)m, erasedFQNType, true);
                    }
                }
                if (p != null) {
                    rv.put(p.getName(), p);
                }
            }
            ++n2;
        }
        return rv;
    }
}

