/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.egit.ui.internal.merge.GitDiffTreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.texteditor.IUpdate;

public class CompareWithEachOtherAction
extends Action
implements IUpdate {
    public static final String COMMAND_ID = "org.eclipse.egit.ui.CompareWithEachOther";
    private final GitDiffTreeViewer viewer;

    public CompareWithEachOtherAction(GitDiffTreeViewer viewer, String label, ImageDescriptor icon) {
        super(label, icon);
        this.viewer = viewer;
        viewer.addSelectionChangedListener(event -> this.update());
    }

    public void run() {
        DiffNode[] nodes = this.getNodes();
        if (nodes.length != 2) {
            return;
        }
        DiffNode newNode = new DiffNode(this.getElement(nodes[0]), this.getElement(nodes[1]));
        StructuredSelection selection = new StructuredSelection((Object)newNode);
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, (ISelection)selection));
    }

    public void update() {
        this.setEnabled(this.getNodes().length == 2);
    }

    private DiffNode[] getNodes() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 2) {
            return new DiffNode[0];
        }
        DiffNode[] nodes = new DiffNode[2];
        int i = 0;
        for (Object obj : selection.toList()) {
            if (!(obj instanceof DiffNode)) continue;
            DiffNode node = (DiffNode)obj;
            if (node.hasChildren() || "FOLDER".equals(node.getType())) {
                return new DiffNode[0];
            }
            nodes[i++] = node;
        }
        return nodes;
    }

    private ITypedElement getElement(DiffNode node) {
        ITypedElement left = node.getLeft();
        if (left != null) {
            return left;
        }
        return node.getRight();
    }
}

