/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.DeleteBranchOperationUI;
import org.eclipse.egit.ui.internal.repository.tree.BranchHierarchyNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class DeleteBranchCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes(event);
        Map<Repository, List<Ref>> refs = this.getRefsToDelete(nodes);
        try {
            DeleteBranchOperationUI.deleteBranches(refs);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException(UIText.RepositoriesView_BranchDeletionFailureMessage, e.getCause());
        }
        return null;
    }

    private Map<Repository, List<Ref>> getRefsToDelete(List<RepositoryTreeNode> nodes) {
        HashMap<Repository, List<Ref>> refs = new HashMap<Repository, List<Ref>>();
        for (RepositoryTreeNode node : nodes) {
            if (node instanceof BranchHierarchyNode) {
                try {
                    for (Ref ref : ((BranchHierarchyNode)node).getChildRefsRecursive()) {
                        refs.computeIfAbsent(node.getRepository(), key -> new ArrayList()).add(ref);
                    }
                }
                catch (IOException e) {
                    Activator.logError(MessageFormat.format(UIText.RepositoriesView_BranchCollectionError, node.getPath(), node.getRepository().getDirectory()), e);
                }
                continue;
            }
            if (!(node instanceof RefNode)) continue;
            refs.computeIfAbsent(node.getRepository(), key -> new ArrayList()).add((Ref)node.getObject());
        }
        return refs;
    }
}

