/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.Equality;

class PackFileSnapshot
extends FileSnapshot {
    private static final ObjectId MISSING_CHECKSUM = ObjectId.zeroId();
    private AnyObjectId checksum = MISSING_CHECKSUM;
    private boolean wasChecksumChanged;

    public static PackFileSnapshot save(File path) {
        return new PackFileSnapshot(path);
    }

    PackFileSnapshot(File packFile) {
        super(packFile);
    }

    void setChecksum(AnyObjectId checksum) {
        this.checksum = checksum;
    }

    @Override
    public boolean isModified(File packFile) {
        if (!super.isModified(packFile)) {
            return false;
        }
        if (this.wasSizeChanged() || this.wasFileKeyChanged() || !this.wasLastModifiedRacilyClean()) {
            return true;
        }
        return this.isChecksumChanged(packFile);
    }

    boolean isChecksumChanged(File packFile) {
        this.wasChecksumChanged = !Equality.isSameInstance(this.checksum, MISSING_CHECKSUM) && !this.checksum.equals(this.readChecksum(packFile));
        return this.wasChecksumChanged;
    }

    private AnyObjectId readChecksum(File packFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RandomAccessFile fd = new RandomAccessFile(packFile, "r");){
                fd.seek(fd.length() - 20L);
                byte[] buf = new byte[20];
                fd.readFully(buf, 0, 20);
                return ObjectId.fromRaw(buf);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return MISSING_CHECKSUM;
        }
    }

    boolean wasChecksumChanged() {
        return this.wasChecksumChanged;
    }

    @Override
    public String toString() {
        return "PackFileSnapshot [checksum=" + String.valueOf(this.checksum) + ", " + super.toString() + "]";
    }
}

