/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.property;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import java.io.IOException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emfcloud.jackson.annotations.JsonAnnotations;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntries;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;
import org.eclipse.emfcloud.jackson.databind.property.EObjectProperty;
import org.eclipse.emfcloud.jackson.databind.type.FeatureKind;
import org.eclipse.emfcloud.jackson.module.EMFModule;

public class EObjectFeatureProperty
extends EObjectProperty {
    private final EStructuralFeature feature;
    private final JavaType javaType;
    private final boolean defaultValues;
    private JsonSerializer<Object> serializer;

    public EObjectFeatureProperty(EStructuralFeature feature, JavaType type, int features) {
        super(JsonAnnotations.getElementName((ENamedElement)feature));
        this.feature = feature;
        this.javaType = type;
        this.defaultValues = EMFModule.Feature.OPTION_SERIALIZE_DEFAULT_VALUE.enabledIn(features);
    }

    @Override
    public void deserializeAndSet(JsonParser jp, EObject current, DeserializationContext ctxt, Resource resource) throws IOException {
        JsonDeserializer deserializer = ctxt.findContextualValueDeserializer(this.javaType, null);
        if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            jp.nextToken();
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_NULL) {
            return;
        }
        switch (FeatureKind.get((ETypedElement)this.feature)) {
            case MAP: 
            case MANY_CONTAINMENT: 
            case SINGLE_CONTAINMENT: {
                EMFContext.setFeature((DatabindContext)ctxt, this.feature);
                EMFContext.setParent((DatabindContext)ctxt, current);
            }
            case SINGLE_ATTRIBUTE: 
            case MANY_ATTRIBUTE: {
                if (this.feature.getEType() instanceof EDataType) {
                    EMFContext.setDataType((DatabindContext)ctxt, this.feature.getEType());
                }
                if (this.feature.isMany()) {
                    deserializer.deserialize(jp, ctxt, current.eGet(this.feature));
                    break;
                }
                Object value = deserializer.deserialize(jp, ctxt);
                if (value == null) break;
                current.eSet(this.feature, value);
                break;
            }
            case MANY_REFERENCE: 
            case SINGLE_REFERENCE: {
                EMFContext.setFeature((DatabindContext)ctxt, this.feature);
                EMFContext.setParent((DatabindContext)ctxt, current);
                ReferenceEntries entries = EMFContext.getEntries((DatabindContext)ctxt);
                if (this.feature.isMany()) {
                    deserializer.deserialize(jp, ctxt, entries.entries());
                    break;
                }
                Object value = deserializer.deserialize(jp, ctxt);
                if (entries == null || !(value instanceof ReferenceEntry)) break;
                entries.entries().add((ReferenceEntry)value);
                break;
            }
        }
    }

    @Override
    public void serialize(EObject bean, JsonGenerator jg, SerializerProvider provider) throws IOException {
        Object value;
        if (this.serializer == null) {
            this.serializer = provider.findValueSerializer(this.javaType);
        }
        EMFContext.setParent((DatabindContext)provider, bean);
        EMFContext.setFeature((DatabindContext)provider, this.feature);
        if (bean.eIsSet(this.feature)) {
            Object value2 = bean.eGet(this.feature, false);
            jg.writeFieldName(this.getFieldName());
            if (this.serializer instanceof UnknownSerializer) {
                JsonSerializer other = provider.findValueSerializer(value2.getClass());
                if (other != null) {
                    other.serialize(value2, jg, provider);
                }
            } else {
                this.serializer.serialize(value2, jg, provider);
            }
        } else if (this.defaultValues && (value = this.feature.getDefaultValue()) != null) {
            jg.writeFieldName(this.getFieldName());
            this.serializer.serialize(value, jg, provider);
        }
    }

    @Override
    public EObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return null;
    }
}

