/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EEnumLiteralImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;
import org.eclipse.emfcloud.jackson.databind.property.EObjectPropertyMap;
import org.eclipse.emfcloud.jackson.databind.ser.EDataTypeSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.EMapStringSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.EObjectSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.EnumeratorSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.ResourceSerializer;
import org.eclipse.emfcloud.jackson.databind.type.EcoreType;
import org.eclipse.emfcloud.jackson.module.EMFModule;

public class EMFSerializers
extends Serializers.Base {
    private final EObjectPropertyMap.Builder propertiesBuilder;
    private final JsonSerializer<EObject> referenceSerializer;
    private final JsonSerializer<Resource> resourceSerializer = new ResourceSerializer();
    private final JsonSerializer<?> dataTypeSerializer = new EDataTypeSerializer();
    private final JsonSerializer<?> mapSerializer = new EMapStringSerializer();
    private final JsonSerializer<?> enumeratorSerializer = new EnumeratorSerializer();

    public EMFSerializers(EMFModule module) {
        this.propertiesBuilder = EObjectPropertyMap.Builder.from(module, module.getFeatures());
        this.referenceSerializer = module.getReferenceSerializer();
    }

    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (type.isTypeOrSubTypeOf(EMap.class) && type.getKeyType().isTypeOrSubTypeOf(String.class)) {
            return this.mapSerializer;
        }
        return super.findMapLikeSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
    }

    public JsonSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (type.getContentType().isReferenceType()) {
            return new CollectionSerializer(type.getContentType(), false, null, this.referenceSerializer);
        }
        return super.findCollectionSerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer);
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        if (type.isTypeOrSubTypeOf(Resource.class)) {
            return this.resourceSerializer;
        }
        if (type.isTypeOrSubTypeOf(Enumerator.class) && !type.isReferenceType() && type.getRawClass() != EEnumLiteralImpl.class) {
            return this.enumeratorSerializer;
        }
        if (type.isReferenceType() || type.isTypeOrSubTypeOf(ReferenceEntry.class)) {
            return this.referenceSerializer;
        }
        if (type.isTypeOrSubTypeOf(EcoreType.DataType.class)) {
            return this.dataTypeSerializer;
        }
        if (type.isTypeOrSubTypeOf(EObject.class)) {
            return new EObjectSerializer(this.propertiesBuilder, this.referenceSerializer);
        }
        return super.findSerializer(config, type, beanDesc);
    }
}

