/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.JavaObjectReference;
import org.eclipse.epsilon.eol.dap.variables.ModelElementReference;
import org.eclipse.epsilon.eol.dap.variables.OpaqueValueReference;
import org.eclipse.epsilon.eol.dap.variables.SingleFrameReference;
import org.eclipse.epsilon.eol.dap.variables.TupleReference;
import org.eclipse.epsilon.eol.dap.variables.collections.CollectionReference;
import org.eclipse.epsilon.eol.dap.variables.collections.PerElementCollectionReference;
import org.eclipse.epsilon.eol.dap.variables.collections.SlicedCollectionReference;
import org.eclipse.epsilon.eol.dap.variables.maps.PerKeyMapReference;
import org.eclipse.epsilon.eol.dap.variables.maps.SlicedMapReference;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.SingleFrame;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IReflectiveModel;
import org.eclipse.epsilon.eol.types.EolTuple;
import org.eclipse.epsilon.eol.types.EolType;

public class SuspendedState {
    public static final int LARGE_COLLECTION_THRESHOLD = 200;
    public static final int SLICE_SIZE = 100;
    private final AtomicInteger nextReference = new AtomicInteger();
    private final BiMap<Integer, IVariableReference> references = HashBiMap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspended() {
        BiMap<Integer, IVariableReference> biMap = this.references;
        synchronized (biMap) {
            this.nextReference.set(0);
            this.references.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariableReference getReference(IEolContext context, SingleFrame sc) {
        BiMap<Integer, IVariableReference> biMap = this.references;
        synchronized (biMap) {
            return this.putOrGetReference(new SingleFrameReference(context, sc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariableReference getReference(int id) {
        BiMap<Integer, IVariableReference> biMap = this.references;
        synchronized (biMap) {
            return (IVariableReference)this.references.get((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getReferenceId(IVariableReference r) {
        BiMap<Integer, IVariableReference> biMap = this.references;
        synchronized (biMap) {
            return (Integer)this.references.inverse().get((Object)r);
        }
    }

    public IVariableReference getValueReference(IEolContext context, String name, Object value) {
        if (value == null) {
            return new OpaqueValueReference(context, name, value);
        }
        IModel model = context.getModelRepository().getOwningModel(value);
        if (model instanceof IReflectiveModel) {
            IReflectiveModel rModel = (IReflectiveModel)model;
            return this.putOrGetReference(new ModelElementReference(context, rModel, name, value));
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            CollectionReference ref = c.size() >= 200 ? new SlicedCollectionReference(context, name, c, 100) : new PerElementCollectionReference(context, name, c);
            return this.putOrGetReference(ref);
        }
        if (value instanceof EolTuple) {
            return this.putOrGetReference(new TupleReference(context, name, (EolTuple)value));
        }
        if (value instanceof Map) {
            Map m = (Map)value;
            IdentifiableReference ref = m.size() >= 200 ? new SlicedMapReference(context, name, m, 100) : new PerKeyMapReference(context, name, m);
            return this.putOrGetReference(ref);
        }
        EolType[] eolTypeArray = IdentifiableReference.PREDEFINED_TYPES;
        int n = IdentifiableReference.PREDEFINED_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            EolType t = eolTypeArray[n2];
            if (t.isKind(value)) {
                return new OpaqueValueReference(context, name, value);
            }
            ++n2;
        }
        return this.putOrGetReference(new JavaObjectReference(context, name, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariableReference putOrGetReference(IdentifiableReference<?> ref) {
        BiMap<Integer, IVariableReference> biMap = this.references;
        synchronized (biMap) {
            Integer reference = (Integer)this.references.inverse().get(ref);
            if (reference == null) {
                reference = this.nextReference.incrementAndGet();
                this.references.put((Object)reference, ref);
            }
            ref.setId(reference);
        }
        return ref;
    }
}

