/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.model.AsNamed;
import org.apache.jena.ontapi.model.HasDisjoint;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDisjoint;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntList;
import org.apache.jena.ontapi.model.OntNamedProperty;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.model.RDFNodeList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public interface OntObjectProperty
extends OntRelationalProperty,
AsNamed<Named>,
HasDisjoint<OntObjectProperty> {
    public Stream<OntObjectProperty> subProperties(boolean var1);

    public Stream<OntObjectProperty> superProperties(boolean var1);

    public Stream<OntList<OntObjectProperty>> propertyChains();

    public OntNegativeAssertion.WithObjectProperty addNegativeAssertion(OntIndividual var1, OntIndividual var2);

    public OntList<OntObjectProperty> createPropertyChain(Collection<OntObjectProperty> var1);

    public OntObjectProperty removePropertyChain(Resource var1) throws OntJenaException;

    @Override
    default public Named asNamed() {
        return this.as(Named.class);
    }

    default public Stream<OntClass> ranges() {
        return this.objects(RDFS.range, OntClass.class).filter(OntClass::canAsSuperClass).map(OntClass::asSuperClass);
    }

    default public Stream<OntClass> ranges(boolean direct) {
        if (direct) {
            return this.ranges();
        }
        return this.ranges().flatMap(d -> Stream.concat(Stream.of(d), d.subClasses(false))).distinct();
    }

    default public Stream<OntObjectProperty> subProperties() {
        return this.subProperties(false);
    }

    default public Stream<OntObjectProperty> superProperties() {
        return this.superProperties(false);
    }

    @Override
    default public Stream<OntDisjoint.ObjectProperties> disjoints() {
        return this.getModel().ontObjects(OntDisjoint.ObjectProperties.class).filter(d -> d.members().anyMatch(this::equals));
    }

    default public Stream<OntObjectProperty> disjointProperties() {
        return this.objects(OWL2.propertyDisjointWith, OntObjectProperty.class);
    }

    default public Stream<OntObjectProperty> equivalentProperties() {
        return this.objects(OWL2.equivalentProperty, OntObjectProperty.class);
    }

    default public Stream<OntObjectProperty> inverseProperties() {
        return this.objects(OWL2.inverseOf, OntObjectProperty.class);
    }

    default public Stream<OntNegativeAssertion.WithObjectProperty> negativeAssertions() {
        return this.getModel().ontObjects(OntNegativeAssertion.WithObjectProperty.class).filter(a -> this.equals(a.getProperty()));
    }

    default public Stream<OntNegativeAssertion.WithObjectProperty> negativeAssertions(OntIndividual source) {
        return this.negativeAssertions().filter(a -> a.getSource().equals(source));
    }

    default public Optional<OntList<OntObjectProperty>> findPropertyChain(RDFNode list) {
        try (Stream<OntList> res = this.propertyChains().filter(r -> Objects.equals(r, list));){
            Optional<OntList<OntObjectProperty>> optional = res.findFirst();
            return optional;
        }
    }

    default public OntObjectProperty clearPropertyChains() {
        this.propertyChains().toList().forEach(this::removePropertyChain);
        return this;
    }

    default public Stream<OntObjectProperty> fromPropertyChain() {
        return this.propertyChains().flatMap(RDFNodeList::members).distinct();
    }

    default public OntStatement addPropertyChainAxiomStatement(OntObjectProperty ... properties) {
        return this.addPropertyChainAxiomStatement(Arrays.asList(properties));
    }

    default public OntStatement addPropertyChainAxiomStatement(Collection<OntObjectProperty> properties) {
        return this.createPropertyChain(properties).getMainStatement();
    }

    default public OntStatement addInverseFunctionalDeclaration() {
        return this.addStatement(RDF.type, OWL2.InverseFunctionalProperty);
    }

    default public OntStatement addTransitiveDeclaration() {
        return this.addStatement(RDF.type, OWL2.TransitiveProperty);
    }

    default public OntStatement addSymmetricDeclaration() {
        return this.addStatement(RDF.type, OWL2.SymmetricProperty);
    }

    default public OntStatement addAsymmetricDeclaration() {
        return this.addStatement(RDF.type, OWL2.AsymmetricProperty);
    }

    default public OntStatement addReflexiveDeclaration() {
        return this.addStatement(RDF.type, OWL2.ReflexiveProperty);
    }

    default public OntStatement addIrreflexiveDeclaration() {
        return this.addStatement(RDF.type, OWL2.IrreflexiveProperty);
    }

    default public OntStatement addInverseOfStatement(OntObjectProperty other) {
        return this.addStatement(OWL2.inverseOf, other);
    }

    default public OntStatement addEquivalentPropertyStatement(OntObjectProperty other) {
        return this.addStatement(OWL2.equivalentProperty, other);
    }

    default public OntStatement addPropertyDisjointWithStatement(OntObjectProperty other) {
        return this.addStatement(OWL2.propertyDisjointWith, other);
    }

    default public OntObjectProperty addSuperProperty(OntObjectProperty property) {
        this.addSubPropertyOfStatement(property);
        return this;
    }

    default public OntObjectProperty addSubProperty(OntObjectProperty property) {
        property.addSubPropertyOfStatement(this);
        return this;
    }

    default public OntObjectProperty addRange(OntClass range) {
        this.addRangeStatement(range);
        return this;
    }

    @Override
    default public OntObjectProperty addDomain(OntClass ce) {
        this.addDomainStatement(ce);
        return this;
    }

    default public OntObjectProperty addEquivalentProperty(OntObjectProperty other) {
        this.addEquivalentPropertyStatement(other);
        return this;
    }

    default public OntObjectProperty addDisjointProperty(OntObjectProperty other) {
        this.addPropertyDisjointWithStatement(other);
        return this;
    }

    default public OntObjectProperty addInverseProperty(OntObjectProperty other) {
        this.addInverseOfStatement(other);
        return this;
    }

    default public OntObjectProperty addPropertyChain(OntObjectProperty ... properties) {
        return this.addPropertyChain(Arrays.asList(properties));
    }

    default public OntObjectProperty addPropertyChain(Collection<OntObjectProperty> properties) {
        this.createPropertyChain(properties);
        return this;
    }

    @Override
    default public OntObjectProperty removeSuperProperty(Resource property) {
        this.remove(RDFS.subPropertyOf, property);
        return this;
    }

    @Override
    default public OntObjectProperty removeSubProperty(Resource property) {
        this.getModel().statements(property, RDFS.subPropertyOf, this).toList().forEach(s -> this.getModel().remove(s.clearAnnotations()));
        return this;
    }

    @Override
    default public OntObjectProperty removeEquivalentProperty(Resource property) {
        this.remove(OWL2.equivalentProperty, property);
        return this;
    }

    @Override
    default public OntObjectProperty removeDisjointProperty(Resource property) {
        this.remove(OWL2.propertyDisjointWith, property);
        return this;
    }

    @Override
    default public OntObjectProperty removeDomain(Resource domain) {
        this.remove(RDFS.domain, domain);
        return this;
    }

    @Override
    default public OntObjectProperty removeRange(Resource range) {
        this.remove(RDFS.range, range);
        return this;
    }

    default public OntObjectProperty removeInverseProperty(Resource other) {
        this.remove(OWL2.inverseOf, other);
        return this;
    }

    @Override
    default public OntObjectProperty setFunctional(boolean functional) {
        if (functional) {
            this.addFunctionalDeclaration();
        } else {
            this.remove(RDF.type, OWL2.FunctionalProperty);
        }
        return this;
    }

    default public Optional<OntObjectProperty> inverseProperty() {
        try (Stream<OntObjectProperty> res = this.inverseProperties();){
            Optional<OntObjectProperty> optional = res.findFirst();
            return optional;
        }
    }

    default public boolean isInverseFunctional() {
        return this.hasType(OWL2.InverseFunctionalProperty);
    }

    default public OntObjectProperty setInverseFunctional(boolean inverseFunctional) {
        if (inverseFunctional) {
            this.addInverseFunctionalDeclaration();
        } else {
            this.remove(RDF.type, OWL2.InverseFunctionalProperty);
        }
        return this;
    }

    default public boolean isTransitive() {
        return this.hasType(OWL2.TransitiveProperty);
    }

    default public OntObjectProperty setTransitive(boolean transitive) {
        if (transitive) {
            this.addTransitiveDeclaration();
        } else {
            this.remove(RDF.type, OWL2.TransitiveProperty);
        }
        return this;
    }

    default public boolean isSymmetric() {
        return this.hasType(OWL2.SymmetricProperty);
    }

    default public OntObjectProperty setSymmetric(boolean symmetric) {
        if (symmetric) {
            this.addSymmetricDeclaration();
        } else {
            this.remove(RDF.type, OWL2.SymmetricProperty);
        }
        return this;
    }

    default public boolean isAsymmetric() {
        return this.hasType(OWL2.AsymmetricProperty);
    }

    default public OntObjectProperty setAsymmetric(boolean asymmetric) {
        if (asymmetric) {
            this.addAsymmetricDeclaration();
        } else {
            this.remove(RDF.type, OWL2.AsymmetricProperty);
        }
        return this;
    }

    default public boolean isReflexive() {
        return this.hasType(OWL2.ReflexiveProperty);
    }

    default public OntObjectProperty setReflexive(boolean reflexive) {
        if (reflexive) {
            this.addReflexiveDeclaration();
        } else {
            this.remove(RDF.type, OWL2.ReflexiveProperty);
        }
        return this;
    }

    default public boolean isIrreflexive() {
        return this.hasType(OWL2.IrreflexiveProperty);
    }

    default public OntObjectProperty setIrreflexive(boolean irreflexive) {
        if (irreflexive) {
            this.addIrreflexiveDeclaration();
        } else {
            this.remove(RDF.type, OWL2.IrreflexiveProperty);
        }
        return this;
    }

    public static interface Named
    extends OntObjectProperty,
    OntNamedProperty<Named> {
        public Inverse createInverse();

        @Override
        default public Named asNamed() {
            return this;
        }
    }

    public static interface Inverse
    extends OntObjectProperty {
        public Named getDirect();
    }
}

