/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.rdf.model.impl.RDFReaderFImpl;
import org.apache.jena.rdf.model.impl.RDFWriterFImpl;
import org.apache.jena.riot.adapters.AdapterFileManager;
import org.apache.jena.riot.adapters.RDFReaderFactoryRIOT;
import org.apache.jena.riot.adapters.RDFWriterFactoryRIOT;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.FileManager;

public class IO_Jena {
    private static FileManager coreFileManager;
    private static boolean readersWiredIn;
    private static boolean writersWiredIn;

    public static void wireIntoJena() {
        IO_Jena.wireReadersIntoJena();
        IO_Jena.wireWritersIntoJena();
    }

    public static void resetJena() {
        IO_Jena.resetJenaCoreReaders();
        IO_Jena.resetJenaCoreWriters();
    }

    private static void wireReadersIntoJena() {
        if (readersWiredIn) {
            return;
        }
        readersWiredIn = true;
        coreFileManager = FileManager.getInternalNoInit();
        RDFReaderFImpl.alternative(new RDFReaderFactoryRIOT());
        FileManager.setGlobalFileManager(AdapterFileManager.get());
    }

    private static void resetJenaCoreReaders() {
        if (!readersWiredIn) {
            return;
        }
        readersWiredIn = false;
        RDFReaderFImpl.alternative(null);
        FileManager.setGlobalFileManager(coreFileManager);
    }

    private static void wireWritersIntoJena() {
        if (writersWiredIn) {
            return;
        }
        writersWiredIn = true;
        RDFWriterFImpl.alternative(new RDFWriterFactoryRIOT());
    }

    private static void resetJenaCoreWriters() {
        if (!writersWiredIn) {
            return;
        }
        writersWiredIn = false;
        RDFWriterFImpl.alternative(null);
    }

    static {
        JenaSystem.init();
        coreFileManager = null;
        readersWiredIn = false;
        writersWiredIn = false;
    }
}

