/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.emf;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.escet.common.emf.prettyprint.IdProvider;
import org.eclipse.escet.common.emf.prettyprint.PrettyEFeat;
import org.eclipse.escet.common.emf.prettyprint.PrettyEObject;
import org.eclipse.escet.common.emf.prettyprint.PrettyFeatEAttribute;
import org.eclipse.escet.common.emf.prettyprint.PrettyFeatEReference;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;

public class EMFPrettyPrinter {
    private static final int MAX_LINE_LENGTH = 100;
    private static final String INDENT_TEXT = "        ";

    private EMFPrettyPrinter() {
    }

    public static String printPrettyTree(EObject rootObject) {
        return EMFPrettyPrinter.printPrettyTree(rootObject, false);
    }

    public static String printPrettyTree(EObject rootObject, boolean printEmptyFeatures) {
        List<PrettyEObject> prettyEObjects = EMFPrettyPrinter.sequenceEObjects(rootObject);
        return EMFPrettyPrinter.printPrettyEObjects(prettyEObjects, printEmptyFeatures);
    }

    private static List<PrettyEObject> sequenceEObjects(EObject rootEObject) {
        Map foundEObjects = Maps.map();
        List prettyEObjects = Lists.list();
        int assignedCount = 0;
        ArrayDeque<EObject> notDone = new ArrayDeque<EObject>();
        notDone.add(rootEObject);
        while (!notDone.isEmpty()) {
            EObject eobj = (EObject)notDone.poll();
            IdProvider idProvider = EMFPrettyPrinter.getIdProvider(eobj, foundEObjects);
            int objId = ++assignedCount;
            idProvider.setIdNumber(objId);
            EClass eClass = eobj.eClass();
            List<EStructuralFeature> structuralFeatures = EMFPrettyPrinter.getAllStructuralFeatures(eClass);
            List prettyFeats = Lists.listc((int)structuralFeatures.size());
            for (EStructuralFeature feat : structuralFeatures) {
                Object obj = eobj.eGet(feat);
                if (feat instanceof EReference) {
                    EReference eRef = (EReference)feat;
                    int numValues = obj == null ? 0 : (feat.isMany() ? ((List)obj).size() : 1);
                    int[] idNumbers = new int[numValues];
                    Arrays.fill(idNumbers, -1);
                    PrettyFeatEReference prettyFeat = new PrettyFeatEReference(eRef, obj, idNumbers);
                    if (obj != null) {
                        if (feat.isMany()) {
                            int index = 0;
                            List eListObjs = (List)obj;
                            for (EObject eListObj : eListObjs) {
                                if (eRef.isContainment()) {
                                    notDone.add(eListObj);
                                }
                                IdProvider featIdProvider = EMFPrettyPrinter.getIdProvider(eListObj, foundEObjects);
                                featIdProvider.registerPrettyFeature(prettyFeat, index);
                                ++index;
                            }
                        } else {
                            if (eRef.isContainment()) {
                                notDone.add((EObject)obj);
                            }
                            IdProvider featIdProvider = EMFPrettyPrinter.getIdProvider((EObject)obj, foundEObjects);
                            featIdProvider.registerPrettyFeature(prettyFeat, 0);
                        }
                    }
                    prettyFeats.add(prettyFeat);
                    continue;
                }
                EAttribute eAttr = (EAttribute)feat;
                prettyFeats.add(new PrettyFeatEAttribute(eAttr, obj));
            }
            String className = eClass.getName();
            PrettyEObject prettyObject = new PrettyEObject(eobj, objId, className, prettyFeats);
            prettyEObjects.add(prettyObject);
        }
        return prettyEObjects;
    }

    private static IdProvider getIdProvider(EObject eObj, Map<EObject, IdProvider> foundEObjects) {
        IdProvider idProvider = foundEObjects.get(eObj);
        if (idProvider == null) {
            idProvider = new IdProvider();
            foundEObjects.put(eObj, idProvider);
        }
        return idProvider;
    }

    private static String printPrettyEObjects(List<PrettyEObject> prettyEObjects, boolean printEmptyFeatures) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (PrettyEObject prettyEObject : prettyEObjects) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("\n");
            }
            String textTerminator = prettyEObject.isEmpty(printEmptyFeatures) ? ";" : ":";
            sb.append(Strings.fmt((String)"[%d] %s%s\n", (Object[])new Object[]{prettyEObject.eObjId, prettyEObject.className, textTerminator}));
            for (PrettyEFeat prettyFeat : prettyEObject.prettyFeats) {
                String featKind;
                if (prettyFeat instanceof PrettyFeatEAttribute) {
                    PrettyFeatEAttribute attr = (PrettyFeatEAttribute)prettyFeat;
                    if (!printEmptyFeatures && attr.isEmpty()) continue;
                    featKind = "Attribute";
                } else if (prettyFeat instanceof PrettyFeatEReference) {
                    PrettyFeatEReference ref = (PrettyFeatEReference)prettyFeat;
                    if (!printEmptyFeatures && ref.isEmpty()) continue;
                    featKind = ref.eReference.isContainment() ? "Contains" : "References";
                } else {
                    throw new AssertionError((Object)("Unexpected pretty feature found: \"" + String.valueOf(prettyFeat) + "\"."));
                }
                Object typeText = prettyFeat.isMany() ? "List<" + prettyFeat.getEType() + ">" : prettyFeat.getEType();
                String featName = prettyFeat.getFeatureName();
                String initialText = Strings.fmt((String)"  - %s %s %s = ", (Object[])new Object[]{featKind, typeText, featName});
                sb.append(initialText);
                int colNum = initialText.length();
                List<String> texts = prettyFeat.getValues();
                if (texts.isEmpty()) {
                    sb.append("[ ]");
                } else if (prettyFeat.isMany()) {
                    colNum = EMFPrettyPrinter.addText("[", sb, colNum, false);
                    boolean nonFirst = false;
                    for (String text : texts) {
                        colNum = EMFPrettyPrinter.addText(text, sb, colNum, nonFirst);
                        nonFirst = true;
                    }
                    EMFPrettyPrinter.addText("]", sb, colNum, false);
                } else {
                    EMFPrettyPrinter.addText(texts.get(0), sb, colNum, false);
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private static int addText(String text, StringBuilder sb, int colNum, boolean addComma) {
        int textLength;
        if (addComma) {
            sb.append(",");
            ++colNum;
        }
        if (colNum + (textLength = text.length() + (addComma ? 1 : 0)) < 100) {
            if (addComma) {
                sb.append(" ");
            }
            sb.append(text);
            return colNum + textLength;
        }
        sb.append("\n        " + text);
        return INDENT_TEXT.length() + text.length();
    }

    private static List<EStructuralFeature> getAllStructuralFeatures(EClass eClass) {
        List feats = Lists.copy((List)eClass.getEAllStructuralFeatures());
        Collections.sort(feats, (a, b) -> a.getName().compareTo(b.getName()));
        return feats;
    }
}

