/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.confluence;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.WarnOutput;

public class ConfluenceCheckConclusion
implements CheckConclusion {
    private final List<Pair<String, String>> cannotProvePairs;

    public ConfluenceCheckConclusion(List<Pair<String, String>> cannotProvePairs) {
        this.cannotProvePairs = cannotProvePairs;
    }

    @Override
    public boolean propertyHolds() {
        return this.cannotProvePairs.isEmpty();
    }

    @Override
    public boolean hasDetails() {
        return !this.propertyHolds();
    }

    @Override
    public void printResult(DebugNormalOutput out, WarnOutput warn) {
        if (this.propertyHolds()) {
            out.line("[OK] The specification has confluence.");
        } else {
            out.line("[ERROR] The specification may NOT have confluence:");
            out.line();
            out.inc();
            String pairText = this.cannotProvePairs.size() == 1 ? "pair" : "pairs";
            out.line("Confluence of the following event %s could not be decided:", new Object[]{pairText});
            out.inc();
            out.line(this.cannotProvePairs.stream().map(Pair::toString).collect(Collectors.joining(", ")));
            out.dec();
            out.dec();
        }
    }
}

