/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.simulator.options;

import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StartupInstanceOption
extends Option<String> {
    static final String DESCRIPTION = "The startup instantiation text, can be either a model or an xper instance for example \"M(1.5, [2,3])\".";

    public static String getStartupInstanceText() {
        String value = (String)Options.get(StartupInstanceOption.class);
        if (value != null && value.isEmpty()) {
            value = null;
        }
        return value;
    }

    public StartupInstanceOption() {
        super("Startup", DESCRIPTION, Character.valueOf('i'), "instance", "INSTANCE", true);
    }

    public String getDefault() {
        return null;
    }

    public String parseValue(String optName, String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    public String[] getCmdLine(Object value) {
        if (value == null) {
            return new String[0];
        }
        return new String[]{"--instance=" + (String)value};
    }

    public OptionGroup<String> createOptionGroup(Composite page) {
        return new OptionGroup<String>(page, Options.getInstance(StartupInstanceOption.class)){
            Label instanceLabel;
            Text instanceText;

            protected void addComponents(Group group) {
                this.instanceLabel = new Label((Composite)group, 0);
                this.instanceLabel.setText("Instance:");
                this.instanceText = new Text((Composite)group, 2052);
                this.layoutGeneric(new Object[]{new Control[]{this.instanceLabel, this.instanceText}}, 0);
            }

            public String getDescription() {
                return StartupInstanceOption.DESCRIPTION;
            }

            public void setToValue(String value) {
                this.instanceText.setText(value == null ? "" : value);
            }

            public String[] getCmdLine() {
                return new String[]{"--instance=" + this.instanceText.getText()};
            }
        };
    }
}

