/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public abstract class SymbolTableEntry {
    public final CifTypeChecker tchecker;
    public CheckStatus status = CheckStatus.NONE;

    public SymbolTableEntry(CifTypeChecker tchecker) {
        this.tchecker = tchecker;
    }

    public boolean isCheckedForUse() {
        return this.status == CheckStatus.USE || this.status == CheckStatus.FULL;
    }

    public boolean isCheckedFull() {
        return this.status == CheckStatus.FULL;
    }

    public final void tcheckForUse() {
        if (this.status == CheckStatus.USE_FAILED) {
            throw new SemanticException();
        }
        if (this.status != CheckStatus.NONE) {
            return;
        }
        try {
            this.tcheckForUseImpl();
        }
        catch (SemanticException ex) {
            this.status = CheckStatus.USE_FAILED;
            throw ex;
        }
    }

    protected abstract void tcheckForUseImpl();

    public abstract void tcheckFull();

    public abstract String getName();

    public abstract String getAbsName();

    public abstract Position getPosition();

    public abstract PositionObject getObject();

    public abstract void changeParent(ParentScope<?> var1);
}

