/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SpecAutomataCountsCheck
extends CifCheckNoCompDefInst {
    public static final int NO_CHANGE = -1;
    private int minAnyAuts = 0;
    private int maxAnyAuts = Integer.MAX_VALUE;
    private int minKindlessAuts = 0;
    private int maxKindlessAuts = Integer.MAX_VALUE;
    private int minPlantAuts = 0;
    private int maxPlantAuts = Integer.MAX_VALUE;
    private int minRequirementAuts = 0;
    private int maxRequirementAuts = Integer.MAX_VALUE;
    private int minSupervisorAuts = 0;
    private int maxSupervisorAuts = Integer.MAX_VALUE;
    private int numAnyAuts;
    private int numKindlessAuts;
    private int numPlantAuts;
    private int numRequirementAuts;
    private int numSupervisorAuts;

    public SpecAutomataCountsCheck setMinMaxAuts(int minValue, int maxValue) {
        this.minAnyAuts = minValue == -1 ? this.minAnyAuts : minValue;
        this.maxAnyAuts = maxValue == -1 ? this.maxAnyAuts : maxValue;
        return this;
    }

    public SpecAutomataCountsCheck setMinMaxKindlessAuts(int minValue, int maxValue) {
        this.minKindlessAuts = minValue == -1 ? this.minKindlessAuts : minValue;
        this.maxKindlessAuts = maxValue == -1 ? this.maxKindlessAuts : maxValue;
        return this;
    }

    public SpecAutomataCountsCheck setMinMaxPlantAuts(int minValue, int maxValue) {
        this.minPlantAuts = minValue == -1 ? this.minPlantAuts : minValue;
        this.maxPlantAuts = maxValue == -1 ? this.maxPlantAuts : maxValue;
        return this;
    }

    public SpecAutomataCountsCheck setMinMaxRequirementAuts(int minValue, int maxValue) {
        this.minRequirementAuts = minValue == -1 ? this.minRequirementAuts : minValue;
        this.maxRequirementAuts = maxValue == -1 ? this.maxRequirementAuts : maxValue;
        return this;
    }

    public SpecAutomataCountsCheck setMinMaxSupervisorAuts(int minValue, int maxValue) {
        this.minSupervisorAuts = minValue == -1 ? this.minSupervisorAuts : minValue;
        this.maxSupervisorAuts = maxValue == -1 ? this.maxSupervisorAuts : maxValue;
        return this;
    }

    protected void preprocessSpecification(Specification spec, CifCheckViolations violations) {
        this.numAnyAuts = 0;
        this.numKindlessAuts = 0;
        this.numPlantAuts = 0;
        this.numRequirementAuts = 0;
        this.numSupervisorAuts = 0;
        Assert.check((this.minAnyAuts >= 0 ? 1 : 0) != 0);
        Assert.check((this.minKindlessAuts >= 0 ? 1 : 0) != 0);
        Assert.check((this.minPlantAuts >= 0 ? 1 : 0) != 0);
        Assert.check((this.minRequirementAuts >= 0 ? 1 : 0) != 0);
        Assert.check((this.minSupervisorAuts >= 0 ? 1 : 0) != 0);
        Assert.check((this.minAnyAuts < Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.check((this.minKindlessAuts < Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.check((this.minPlantAuts < Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.check((this.minRequirementAuts < Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.check((this.minSupervisorAuts < Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.check((this.minAnyAuts <= this.maxAnyAuts ? 1 : 0) != 0);
        Assert.check((this.minKindlessAuts <= this.maxKindlessAuts ? 1 : 0) != 0);
        Assert.check((this.minPlantAuts <= this.maxPlantAuts ? 1 : 0) != 0);
        Assert.check((this.minRequirementAuts <= this.maxRequirementAuts ? 1 : 0) != 0);
        Assert.check((this.minSupervisorAuts <= this.maxSupervisorAuts ? 1 : 0) != 0);
    }

    protected void postprocessSpecification(Specification spec, CifCheckViolations violations) {
        this.checkAndReport(spec, this.numAnyAuts, this.minAnyAuts, this.maxAnyAuts, "", violations);
        this.checkAndReport(spec, this.numKindlessAuts, this.minKindlessAuts, this.maxKindlessAuts, "kindless ", violations);
        this.checkAndReport(spec, this.numRequirementAuts, this.minRequirementAuts, this.maxRequirementAuts, "requirement ", violations);
        this.checkAndReport(spec, this.numPlantAuts, this.minPlantAuts, this.maxPlantAuts, "plant ", violations);
        this.checkAndReport(spec, this.numSupervisorAuts, this.minSupervisorAuts, this.maxSupervisorAuts, "supervisor ", violations);
    }

    private void checkAndReport(Specification spec, int numAuts, int minAuts, int maxAuts, String kindText, CifCheckViolations violations) {
        if (minAuts == 0 && maxAuts == Integer.MAX_VALUE) {
            return;
        }
        String requiredMesg = minAuts == maxAuts ? (minAuts == 0 ? Strings.fmt((String)"Specification does not have exactly 0 %sautomata", (Object[])new Object[]{kindText}) : (minAuts == 1 ? Strings.fmt((String)"Specification does not have exactly 1 %sautomaton", (Object[])new Object[]{kindText}) : Strings.fmt((String)"Specification does not have exactly %d %sautomata", (Object[])new Object[]{minAuts, kindText}))) : (maxAuts == Integer.MAX_VALUE ? (minAuts == 1 ? Strings.fmt((String)"Specification does not have at least 1 %sautomaton", (Object[])new Object[]{kindText}) : Strings.fmt((String)"Specification does not have at least %d %sautomata", (Object[])new Object[]{minAuts, kindText})) : (maxAuts == 1 ? Strings.fmt((String)"Specification does not have at most 1 %sautomaton", (Object[])new Object[]{kindText}) : (minAuts == 0 ? Strings.fmt((String)"Specification does not have at most %d %sautomata", (Object[])new Object[]{maxAuts, kindText}) : Strings.fmt((String)"Specification does not have at least %d and at most %d %sautomata", (Object[])new Object[]{minAuts, maxAuts, kindText}))));
        if (numAuts < minAuts) {
            if (numAuts == 0) {
                violations.add((PositionObject)spec, "%s (no %sautomaton found)", requiredMesg, kindText);
            } else if (numAuts == 1) {
                violations.add((PositionObject)spec, "%s (1 %sautomaton found)", requiredMesg, kindText);
            } else {
                violations.add((PositionObject)spec, "%s (%d %sautomata found)", requiredMesg, numAuts, kindText);
            }
            return;
        }
        if (numAuts > maxAuts) {
            if (numAuts == 1) {
                violations.add((PositionObject)spec, "%s (1 %sautomaton found)", requiredMesg, kindText);
            } else {
                violations.add((PositionObject)spec, "%s (%d %sautomata found)", requiredMesg, numAuts, kindText);
            }
        }
    }

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        ++this.numAnyAuts;
        switch (aut.getKind()) {
            case NONE: {
                ++this.numKindlessAuts;
                break;
            }
            case PLANT: {
                ++this.numPlantAuts;
                break;
            }
            case REQUIREMENT: {
                ++this.numRequirementAuts;
                break;
            }
            case SUPERVISOR: {
                ++this.numSupervisorAuts;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected automaton SupKind found.");
            }
        }
    }
}

