/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.box;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public class OutputStreamCodeBox
extends CodeBox
implements Closeable {
    private static final byte[] NL_BYTES = Strings.NL.getBytes(StandardCharsets.UTF_8);
    private final OutputStream stream;
    private final String description;
    private boolean empty = true;

    public OutputStreamCodeBox(OutputStream stream, String description) {
        this(stream, description, 4);
    }

    public OutputStreamCodeBox(OutputStream stream, String description, int indentAmount) {
        super(indentAmount);
        this.stream = stream;
        this.description = description;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    protected void addLine(String line) {
        this.empty = false;
        line = StringUtils.stripEnd((String)line, null);
        byte[] bytes = line.getBytes(StandardCharsets.UTF_8);
        try {
            this.stream.write(bytes);
            this.stream.write(NL_BYTES);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to write to %s.", (Object[])new Object[]{this.description});
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    @Override
    public List<String> getLines() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to close %s.", (Object[])new Object[]{this.description});
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }
}

