/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ActorClassDataGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;

    public void doGenerate(Root root) {
        HashMap ac2wired = new HashMap();
        Functions.Function1 function1 = w -> w instanceof WiredActorClass;
        Consumer<WiredStructureClass> consumer = w -> ac2wired.put(((WiredActorClass)w).getActorClass(), (WiredActorClass)w);
        IterableExtensions.filter((Iterable)root.getWiredInstances(), (Functions.Function1)function1).forEach(consumer);
        Functions.Function1 function12 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Functions.Function1 function13 = it -> root.getExpandedActorClass(it);
        Consumer<ExpandedActorClass> consumer2 = xpac -> {
            WiredActorClass wired = (WiredActorClass)ac2wired.get(xpac.getActorClass());
            String path = this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
            String string = xpac.getActorClass().getName();
            String file = string + "_DataObject.java";
            this.fileIO.generateFile("generating ActorClass implementation", path + file, this.generate(root, (ExpandedActorClass)xpac, wired));
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)root.getActorClasses(), (Functions.Function1)function12), (Functions.Function1)function13).forEach(consumer2);
    }

    public CharSequence generate(Root root, ExpandedActorClass xpac, WiredActorClass wired) {
        String string;
        boolean bl;
        String string2 = null;
        ActorClass ac = xpac.getActorClass();
        String string3 = ac.getName();
        String clsname = string3 + "_DataObject";
        EList models = root.getReferencedModels((RoomClass)ac);
        Object object = null;
        ModelComponent modelComponent = ac.getBase();
        boolean bl2 = bl = modelComponent != null;
        if (bl) {
            String string4 = ac.getActorBase().getName();
            string = "extends " + string4;
            object = string + "_DataObject ";
        } else {
            object = "";
        }
        String baseClass = object;
        string = new StringConcatenation();
        string.append("package ");
        String string5 = this._roomExtensions.getPackage((RoomClass)ac);
        string.append(string5);
        string.append(";");
        string.newLineIfNotEmpty();
        string.newLine();
        string.append("import org.eclipse.etrice.runtime.java.modelbase.IActorClassDataObject;");
        string.newLine();
        for (RoomModel model : models) {
            string.append("import ");
            String string6 = model.getName();
            string.append(string6);
            string.append(".*;");
            string.newLineIfNotEmpty();
        }
        string.newLine();
        string.append("public class ");
        string.append(clsname);
        string.append(" ");
        string.append(baseClass);
        string.append("implements IActorClassDataObject {");
        string.newLineIfNotEmpty();
        string.append("\t");
        string.newLine();
        boolean bl3 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (bl3) {
            string.append("\t");
            string.append("// state and history");
            string.newLine();
            string.append("\t");
            string.append("private int state;");
            string.newLine();
            string.append("\t");
            string.append("private int[] history;");
            string.newLine();
            string.append("\t");
            string.newLine();
        }
        string.append("\t");
        CharSequence charSequence = this._procedureHelpers.attributes((List)ac.getAttributes());
        string.append((Object)charSequence, "\t");
        string.newLineIfNotEmpty();
        string.append("\t");
        string.newLine();
        boolean bl4 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (bl4) {
            string.append("\t");
            string.append("public int getState() {");
            string.newLine();
            string.append("\t");
            string.append("\t");
            string.append("return state;");
            string.newLine();
            string.append("\t");
            string.append("}");
            string.newLine();
            string.append("\t");
            string.newLine();
            string.append("\t");
            string.append("public void setState(int state) {");
            string.newLine();
            string.append("\t");
            string.append("\t");
            string.append("this.state = state;");
            string.newLine();
            string.append("\t");
            string.append("}");
            string.newLine();
            string.append("\t");
            string.newLine();
            string.append("\t");
            string.append("public int[] getHistory() {");
            string.newLine();
            string.append("\t");
            string.append("\t");
            string.append("return history;");
            string.newLine();
            string.append("\t");
            string.append("}");
            string.newLine();
            string.append("\t");
            string.newLine();
            string.append("\t");
            string.append("public void setHistory(int[] history)  {");
            string.newLine();
            string.append("\t");
            string.append("\t");
            string.append("this.history = history;");
            string.newLine();
            string.append("\t");
            string.append("}");
            string.newLine();
            string.append("\t");
            string.newLine();
        }
        string.append("\t");
        CharSequence charSequence2 = this._procedureHelpers.attributeSettersGettersImplementation((List)ac.getAttributes(), ac.getName());
        string.append((Object)charSequence2, "\t");
        string.newLineIfNotEmpty();
        string.append("\t");
        string.newLine();
        string.append("};");
        string.newLine();
        string2 = string;
        return string2;
    }
}

