/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.context;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.handly.context.GuiceContext;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.util.Property;

public class GuiceContextTest
extends TestCase {
    private static final String NAME = "aName";
    private final IContext ctx = new GuiceContext(Guice.createInjector((com.google.inject.Module[])new com.google.inject.Module[]{new Module()}));

    public void test01() {
        Property p = Property.get((String)NAME, String.class);
        GuiceContextTest.assertTrue((boolean)this.ctx.containsKey(p));
        GuiceContextTest.assertEquals((String)"123", (String)((String)this.ctx.get(p)));
        GuiceContextTest.assertEquals((String)"123", (String)((String)this.ctx.getOrDefault(p)));
    }

    public void test02() {
        Property p = Property.get((String)NAME, Integer.class);
        GuiceContextTest.assertTrue((boolean)this.ctx.containsKey(p));
        GuiceContextTest.assertEquals((Object)123, (Object)this.ctx.get(p));
        GuiceContextTest.assertEquals((Object)123, (Object)this.ctx.getOrDefault(p));
    }

    public void test03() {
        Property<List<String>> p = new Property<List<String>>(NAME){};
        GuiceContextTest.assertTrue((boolean)this.ctx.containsKey((Property)p));
        GuiceContextTest.assertEquals(Arrays.asList("1", "2", "3"), (Object)this.ctx.get((Property)p));
        GuiceContextTest.assertEquals(Arrays.asList("1", "2", "3"), (Object)this.ctx.getOrDefault((Property)p));
    }

    public void test04() {
        Property p = Property.get((String)NAME, Object.class).withDefault((Object)"foo");
        GuiceContextTest.assertFalse((boolean)this.ctx.containsKey(p));
        GuiceContextTest.assertNull((Object)this.ctx.get(p));
        GuiceContextTest.assertEquals((Object)"foo", (Object)this.ctx.getOrDefault(p));
    }

    public void test05() {
        GuiceContextTest.assertTrue((boolean)this.ctx.containsKey(String.class));
        GuiceContextTest.assertEquals((String)"007", (String)((String)this.ctx.get(String.class)));
    }

    public void test06() {
        GuiceContextTest.assertTrue((boolean)this.ctx.containsKey(Integer.class));
        GuiceContextTest.assertEquals((Object)7, (Object)this.ctx.get(Integer.class));
    }

    public void test07() {
        GuiceContextTest.assertTrue((boolean)this.ctx.containsKey(Object.class));
        GuiceContextTest.assertEquals((Object)"000", (Object)this.ctx.get(Object.class));
    }

    public void test08() {
        GuiceContextTest.assertFalse((boolean)this.ctx.containsKey(List.class));
        GuiceContextTest.assertNull((Object)this.ctx.get(List.class));
    }

    private static class Module
    extends AbstractModule {
        private Module() {
        }

        protected void configure() {
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)GuiceContextTest.NAME)).toInstance((Object)"123");
            this.bind((TypeLiteral)new TypeLiteral<List<String>>(){}).annotatedWith((Annotation)Names.named((String)GuiceContextTest.NAME)).toInstance(new ArrayList<String>(Arrays.asList("1", "2", "3")));
            this.bind(String.class).toInstance((Object)"007");
            this.bind(Object.class).toInstance((Object)"000");
        }
    }
}

