/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.lifecycle;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.TimerBeanBase;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.Schedule;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Schedules;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerHandle;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import java.io.Serializable;
import java.util.Date;

@Stateless
public class ScheduleBean
extends TimerBeanBase {
    protected static final String YEAR_5000 = "year5000";
    protected static final String NON_PERSISTENT_TIMER = "non-persistent";

    @Schedules(value={@Schedule(year="5000", info="year5000"), @Schedule(year="5000", info="non-persistent", persistent=false)})
    private void year5000() {
        throw new IllegalStateException("We will not see this in our life.");
    }

    public String compareTimer(Timer timer) {
        Timer expected = TimerUtil.findTimer(this.timerService, (String)((Object)timer.getInfo()));
        return Helper.assertEquals("Compare timer passed from web component to that in TimerService", expected, timer);
    }

    public String compareTimer(TimerHandle timerHandle) {
        return this.compareTimer(timerHandle.getTimer());
    }

    public TimerHandle getTimerHandle(Timer timer) {
        return timer.isPersistent() ? timer.getHandle() : null;
    }

    public Timer getTimer(TimerHandle handle) {
        return handle.getTimer();
    }

    public String getTimerExpired(TimerHandle handle) {
        String result = null;
        try {
            Timer t = handle.getTimer();
            result = "Expecting NoSuchObjectLocalException but got " + t;
            throw new RuntimeException(result);
        }
        catch (NoSuchObjectLocalException e) {
            result = "Got expected " + e;
            return result;
        }
    }

    public void cancelTimer(TimerHandle timerHandle) {
        timerHandle.getTimer().cancel();
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void cancelTimerWithNoTransaction(Timer timer) {
        timer.cancel();
    }

    public String timerHandleIllegalStateException() {
        StringBuilder sb = new StringBuilder();
        ScheduleExpression exp = new ScheduleExpression().year(5000);
        TimerConfig config = new TimerConfig((Serializable)((Object)"timerHandleIllegalStateException"), false);
        Date initial = TimerUtil.getCurrentDatePlus(1, 1);
        long interval = 86400000L;
        this.timerHandleIllegalStateException0(this.findTimer(NON_PERSISTENT_TIMER), sb);
        this.timerHandleIllegalStateException0(this.timerService.createCalendarTimer(exp, config), sb);
        this.timerHandleIllegalStateException0(this.timerService.createIntervalTimer(initial, interval, config), sb);
        this.timerHandleIllegalStateException0(this.timerService.createIntervalTimer(initial, interval, config), sb);
        this.timerHandleIllegalStateException0(this.timerService.createSingleActionTimer(initial, config), sb);
        this.timerHandleIllegalStateException0(this.timerService.createSingleActionTimer(initial.getTime(), config), sb);
        return sb.toString();
    }

    public String isCalendarTimerAndGetSchedule() {
        StringBuilder sb = new StringBuilder();
        ScheduleExpression exp = new ScheduleExpression().year(5000);
        TimerConfig config = new TimerConfig((Serializable)((Object)"isCalendarTimer"), false);
        Date initial = TimerUtil.getCurrentDatePlus(1, 1);
        long interval = 86400000L;
        String info = "isCalendarTimer";
        this.isCalendarTimerAndGetSchedule0(this.findTimer(YEAR_5000), true, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createCalendarTimer(exp, config), true, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createIntervalTimer(initial, interval, config), false, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createIntervalTimer(initial, interval, config), false, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createSingleActionTimer(initial, config), false, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createSingleActionTimer(initial.getTime(), config), false, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createSingleActionTimer(initial, new TimerConfig((Serializable)((Object)info), false)), false, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createSingleActionTimer(initial.getTime(), new TimerConfig((Serializable)((Object)info), false)), false, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createIntervalTimer(initial, interval, new TimerConfig((Serializable)((Object)info), false)), false, sb);
        this.isCalendarTimerAndGetSchedule0(this.timerService.createIntervalTimer(initial.getTime(), interval, new TimerConfig((Serializable)((Object)info), false)), false, sb);
        return sb.toString();
    }

    private void isCalendarTimerAndGetSchedule0(Timer t, boolean expected, StringBuilder sb) {
        Helper.assertEquals(null, expected, t.isCalendarTimer(), sb);
        ScheduleExpression exp = null;
        if (expected) {
            exp = t.getSchedule();
            sb.append(" Got expected ScheduleExpression when calling getSchedule: " + exp);
        } else {
            try {
                exp = t.getSchedule();
                sb.append("Expecting IllegalStateException when calling getSchedule on a non-schedule timer, but got " + exp);
                throw new RuntimeException(sb.toString());
            }
            catch (IllegalStateException e) {
                sb.append(" Got expected IllegalStateException when calling getSchedule on a non-schedule timer.");
            }
        }
    }

    private void timerHandleIllegalStateException0(Timer t, StringBuilder sb) {
        TimerHandle h = null;
        try {
            h = t.getHandle();
            sb.append("Expecting IllegalStateException when calling getHandle on a non-persistent timer, but got " + h);
            throw new RuntimeException(sb.toString());
        }
        catch (IllegalStateException e) {
            sb.append(" Got expected IllegalStateException when calling getHandle on a non-persistent timer");
            return;
        }
    }
}

