/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.attributeoverride;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.attributeoverride.LawBook;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final int ENTITY_ID = 3039;
    private static final String NAME = "Cheese";
    private static final String PUBLISHER = "Johnson";
    private static final int COST = 20;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception:test failed ", (Throwable)e);
        }
    }

    public void testNoAttributeOverrideAnnotation() throws EETest.Fault {
        block6: {
            LawBook book = new LawBook();
            this.getEntityTransaction().begin();
            book.setCategory("Motivational");
            book.setId(Integer.valueOf(3039));
            book.setName(NAME);
            book.setPublisher(PUBLISHER);
            book.setCost(20);
            this.getEntityManager().persist((Object)book);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createQuery("SELECT b FROM LawBook b where b.name= :name").setParameter("name", (Object)NAME).getResultList();
                if (result.size() == 1) {
                    TestUtil.logTrace((String)"test Overriding Attributes passed");
                    break block6;
                }
                throw new EETest.Fault("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testNoAttributeOverrideAnnotation" + e);
            }
            finally {
                this.getEntityManager().remove((Object)book);
                this.getEntityTransaction().commit();
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM LAWBOOK").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

