/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.elementcollection;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.elementcollection.A;
import com.sun.ts.tests.jpa.core.annotations.elementcollection.Address;
import com.sun.ts.tests.jpa.core.annotations.elementcollection.Customer;
import com.sun.ts.tests.jpa.core.annotations.elementcollection.CustomerXML;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setupA(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeATestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupCust(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeCustTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupA")
    @CleanupMethod(name="cleanupA")
    public void elementCollectionEmbeddableType() throws EETest.Fault {
        boolean pass = false;
        A aRef = null;
        try {
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA", "01801");
            Address addr2 = new Address("Some Address", "Boston", "MA", "01803");
            HashSet<Address> s1 = new HashSet<Address>();
            s1.add(addr1);
            s1.add(addr2);
            aRef = new A("1", "bean1", 1);
            aRef.setAddress(s1);
            TestUtil.logTrace((String)"Persisting A");
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)aRef);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            A newA = this.findA("1");
            Set newAddressSet = newA.getAddress();
            this.dumpAddresses(newAddressSet);
            boolean pass1 = false;
            boolean pass2 = false;
            boolean pass3 = true;
            for (Address addr : newAddressSet) {
                if (addr != null) {
                    if (addr.getStreet().equals("1 Network Drive") && addr.getCity().equals("Burlington") && addr.getState().equals("MA") && addr.getZip().equals("01801")) {
                        pass1 = true;
                        TestUtil.logTrace((String)("pass1 = " + pass1));
                    }
                    if (!addr.getStreet().equals("Some Address") || !addr.getCity().equals("Boston") || !addr.getState().equals("MA") || !addr.getZip().equals("01803")) continue;
                    pass2 = true;
                    TestUtil.logTrace((String)("pass2 = " + pass2));
                    continue;
                }
                TestUtil.logTrace((String)"address=null");
                pass3 = false;
            }
            if (pass1 && pass2 && pass3) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("elementCollectionEmbeddableType failed");
        }
    }

    @SetupMethod(name="setupCust")
    @CleanupMethod(name="cleanupCust")
    public void elementCollectionBasicType() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            TestUtil.logTrace((String)("Persisting Customer:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                TestUtil.logTrace((String)("Found Customer: " + cust.toString()));
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    TestUtil.logTrace((String)"Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logTrace((String)("phone:" + s));
                    }
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    for (String s : expectedphones) {
                        TestUtil.logErr((String)("expected:" + s));
                    }
                    TestUtil.logErr((String)"actual:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logErr((String)("actual:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("elementCollectionBasicType failed");
        }
    }

    @SetupMethod(name="setupCust")
    @CleanupMethod(name="cleanupCust")
    public void elementCollectionBasicTypeXMLTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CustomerXML expected = new CustomerXML("1");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            TestUtil.logTrace((String)("Persisting Customer:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Customer and Country and verify them");
            CustomerXML cust = (CustomerXML)this.getEntityManager().find(CustomerXML.class, (Object)expected.getId());
            if (cust != null) {
                TestUtil.logTrace((String)("Found CustomerXML: " + cust.toString()));
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    TestUtil.logTrace((String)"Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logTrace((String)("phone:" + s));
                    }
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    for (String s : expectedphones) {
                        TestUtil.logErr((String)("expected:" + s));
                    }
                    TestUtil.logErr((String)"actual:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logErr((String)("actual:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("elementCollectionBasicTypeXMLTest failed");
        }
    }

    private A findA(String id) {
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void dumpAddresses(Set<Address> addr) {
        TestUtil.logTrace((String)"address Data");
        TestUtil.logTrace((String)"---------------");
        if (addr != null) {
            TestUtil.logTrace((String)("size=" + addr.size()));
            int elem = 1;
            for (Address v : addr) {
                TestUtil.logTrace((String)("- Element #" + elem++));
                TestUtil.logTrace((String)("  street=" + v.getStreet() + ", city=" + v.getCity() + ", state=" + v.getState() + ", zip=" + v.getZip()));
            }
        } else {
            TestUtil.logTrace((String)"  address=NULL");
        }
    }

    public void cleanupA() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeATestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupCust() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeCustTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeCustTestData() {
        TestUtil.logTrace((String)"removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private void removeATestData() {
        TestUtil.logTrace((String)"removeATestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from A_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from AEC").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

