/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.collectionattribute;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.collectionattribute.Uni1XMPerson;
import com.sun.ts.tests.jpa.core.metamodelapi.collectionattribute.Uni1XMProject;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getCollectionType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute colAttrib = mType.getCollection("projects", Uni1XMProject.class);
                PluralAttribute.CollectionType pluralColType = colAttrib.getCollectionType();
                TestUtil.logTrace((String)("collection Type = " + colAttrib.getCollectionType()));
                if (pluralColType == PluralAttribute.CollectionType.COLLECTION) {
                    TestUtil.logTrace((String)("Received Expected Collection type = " + pluralColType));
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("Received UnExpected Collection type = " + pluralColType));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionType Test  failed");
        }
    }

    public void getElementType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                CollectionAttribute colAttrib = mType.getCollection("projects", Uni1XMProject.class);
                TestUtil.logTrace((String)("collection Element Type = " + colAttrib.getElementType().getJavaType().getName()));
                String elementTypeName = colAttrib.getElementType().getJavaType().getName();
                if (elementTypeName.equals("com.sun.ts.tests.jpa.core.metamodelapi.collectionattribute.Uni1XMProject")) {
                    TestUtil.logTrace((String)("Received Expected Element type = " + elementTypeName));
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("Received UnExpected Element type = " + elementTypeName));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getElementType Test  failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"in cleanup");
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception fe) {
            TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
        }
        TestUtil.logTrace((String)"done cleanup, calling super.cleanup");
        super.cleanup();
    }
}

