/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.sec.annotations.ejb.clientcert;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices12.sec.annotations.ejb.clientcert.Hello;
import com.sun.ts.tests.webservices12.sec.annotations.ejb.clientcert.HelloService;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceRef;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class Client
extends EETest {
    @WebServiceRef
    static HelloService service;
    private Hello port;
    private Properties props = null;
    private TSURL ctsurl = new TSURL();
    private String hostname = "localhost";
    private String PROTOCOL = "https";
    private String urlString = null;
    private int portnum = 8000;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.hostname = this.props.getProperty("webServerHost");
            this.portnum = Integer.parseInt(this.props.getProperty("securedWebServicePort"));
            String tlsVersion = p.getProperty("client.cert.test.jdk.tls.client.protocols");
            if (tlsVersion != null) {
                TestUtil.logMsg((String)("client.cert.test.jdk.tls.client.protocols=" + tlsVersion));
                System.setProperty("https.protocols", tlsVersion);
            }
            this.urlString = this.ctsurl.getURLString(this.PROTOCOL, this.hostname, this.portnum, "/WSEjbClientCert/HelloService/Hello");
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
        TestUtil.logMsg((String)"setup ok");
    }

    public void sayHelloProtected() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)("Getting port from the Service : " + service));
            Hello port = service.getHelloPort();
            TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
            BindingProvider bindingProvider = (BindingProvider)port;
            Map map = bindingProvider.getRequestContext();
            map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
            TestUtil.logMsg((String)"Invoking sayHelloProtected on Hello port");
            String text = port.sayHelloProtected("Raja");
            TestUtil.logMsg((String)("Got Output : " + text));
            TestUtil.logMsg((String)"Test sayHelloProtected passed");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EETest.Fault("Test sayHelloProtected failed");
        }
    }

    public void sayHelloPermitAll() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)("Getting port from the Service : " + service));
            Hello port = service.getHelloPort();
            TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
            BindingProvider bindingProvider = (BindingProvider)port;
            Map map = bindingProvider.getRequestContext();
            map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
            TestUtil.logMsg((String)"Invoking sayHelloPermitAll on Hello port");
            String text = port.sayHelloPermitAll("Raja");
            TestUtil.logMsg((String)("Got Output : " + text));
            TestUtil.logMsg((String)"Test sayHelloPermitAll passed");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EETest.Fault("Test sayHelloPermitAll failed");
        }
    }

    public void sayHelloDenyAll() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)("Getting port from the Service : " + service));
            Hello port = service.getHelloPort();
            TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
            BindingProvider bindingProvider = (BindingProvider)port;
            Map map = bindingProvider.getRequestContext();
            map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
            TestUtil.logMsg((String)"Invoking sayHelloDenyAll on Hello port");
            String text = port.sayHelloDenyAll("Raja");
            TestUtil.logErr((String)"Test sayHelloDenyAll failed, didn't get the expected exception");
            TestUtil.logErr((String)("Got Output : " + text));
            throw new EETest.Fault("Test sayHelloDenyAll failed");
        }
        catch (WebServiceException e) {
            TestUtil.logMsg((String)"Got expected WebServiceException");
            TestUtil.logMsg((String)"Test sayHelloDenyAll Passed");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected Exception " + e.getMessage()));
            throw new EETest.Fault("Test sayHelloDenyAll failed", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

