/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.remove.basic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.remove.basic.A;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin removeBasicTest1");
        boolean pass = false;
        A a1 = new A("1", "a1", 1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove((Object)a1);
            pass = true;
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            TestUtil.logErr((String)"Unexpected Exception during remove operation.  Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("removeBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin removeBasicTest2");
        boolean pass = false;
        A a1 = new A("2", "a2", 2);
        this.createA(a1);
        this.getEntityTransaction().begin();
        try {
            A newA = this.findA("2");
            this.getEntityManager().remove((Object)newA);
            TestUtil.logTrace((String)"Call contains after remove()");
            pass = !this.getEntityManager().contains((Object)newA);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("removeBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest3() throws EETest.Fault {
        A a1 = new A("4", "a4", 4);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Persist Instance");
            this.getEntityManager().persist((Object)a1);
            if (this.getEntityManager().contains((Object)a1)) {
                try {
                    this.getEntityManager().remove((Object)a1);
                    this.getEntityManager().flush();
                    A stillExists = this.findA("4");
                    if (stillExists == null) {
                        this.getEntityManager().remove((Object)a1);
                        pass = true;
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception caught trying to remove a removed entity, should have been ignored", (Throwable)e);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"entity not managed, unexpected, test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("removeBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin removeBasicTest4");
        boolean pass = false;
        A a1 = new A("5", "a5", 5);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a1);
        try {
            A newA = this.findA("5");
            if (null != newA) {
                TestUtil.logTrace((String)"Found newA, try Remove");
                this.getEntityManager().remove((Object)newA);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"Removed, try to find and verify the entity has been removed");
                newA = this.findA("5");
                if (null == newA) {
                    TestUtil.logTrace((String)"NewA is Null as expected");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Could not find persisted entity.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Unexpected Exception attempting to find removed entity:" + e));
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("removeBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest5() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin removeBasicTest5");
        boolean pass = false;
        A a1 = new A("6", "a6", 6);
        this.createA(a1);
        try {
            this.getEntityTransaction().begin();
            A a2 = this.findA("6");
            this.getEntityManager().remove((Object)a2);
            if (!this.getEntityManager().contains((Object)a2)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Unexpected Exception caught:" + e));
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("removeBasicTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMergeBasicTest() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin removeMergeBasicTest");
        boolean pass = false;
        String reason = null;
        String aId = "7";
        A a1 = new A("7", "a7", 7);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            this.getEntityManager().remove((Object)a1);
            try {
                this.getEntityManager().merge((Object)a1);
            }
            catch (IllegalArgumentException e) {
                TestUtil.logTrace((String)("Got expected exception when merging a removed entity:" + e));
                pass = true;
            }
            if (!pass) {
                this.getEntityTransaction().commit();
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("This exception may be expected, but we need to check if the commit really failed:" + e));
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            A aFound = this.findA("7");
            if (aFound == null) {
                pass = true;
                TestUtil.logTrace((String)"No entity with id 7 was found.  The commit must have failed, as expected.");
            } else {
                reason = "Entity with id 7 was found: " + aFound + ".  It means the previous commit unexpectedly succeeded.";
                TestUtil.logTrace((String)reason);
            }
        }
        if (!pass) {
            throw new EETest.Fault("removeMergeBasicTest failed, reason: " + reason);
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

