/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.timer.entity.cmp20;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.ejb.wrappers.StatefulWrapper;
import com.sun.ts.tests.ejb.ee.timer.common.TimerImpl;
import com.sun.ts.tests.ejb.ee.timer.entity.cmp20.TestBeanLocal;
import com.sun.ts.tests.ejb.ee.timer.entity.cmp20.TestBeanLocalHome;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.TimerHandle;
import java.io.Serializable;

public class ProxyBeanEJB
extends StatefulWrapper {
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private static final String AuthUser = "authuser";
    private String authuser = "";
    private String username = "";
    private String password = "";
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private TestBeanLocalHome beanHome;
    private TestBeanLocal beanRef;
    private TimerHandle handle;

    public ProxyBeanEJB() {
        TestUtil.logTrace((String)"ProxyBeanEJB no arg constructor");
    }

    public boolean setup() {
        try {
            this.authuser = this.props.getProperty(AuthUser);
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            TestUtil.logTrace((String)"Getting the EJB Local Home interface for java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanLocalHome)this.nctx.lookup(testLookup, TestBeanLocalHome.class);
            TestUtil.logTrace((String)"Creating EJB TestBeanLocal instance");
            this.beanRef = this.beanHome.create(this.props, 1, "expresso", 10.5f);
            TestUtil.logTrace((String)"Initializing logging for TestBean instance");
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("Proxy bean setup", e);
            return false;
        }
    }

    public void cleanup() {
        try {
            if (this.beanRef == null) {
                this.beanRef = this.beanHome.create(this.props, 1, "expresso", 10.5f);
            }
            this.beanRef.cancelAllTimers();
        }
        catch (Exception e) {
            TimerImpl.handleException("Exception in cancelAllTimers", e);
        }
        if (this.beanRef != null) {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TimerImpl.handleException("Exception while removing test bean", e);
            }
        }
    }

    public boolean initializeTimer(int timerType, int timeoutAction) {
        try {
            TestUtil.logTrace((String)"Execute TestBeanLocal:initializeTimer");
            this.handle = this.beanRef.initializeTimerHandle(timerType, timeoutAction);
            return this.handle != null;
        }
        catch (Exception e) {
            TimerImpl.handleException("initializeTimer", e);
            return false;
        }
    }

    public boolean initializeAndCancelTimer(int timerType) {
        try {
            this.handle = this.beanRef.initializeTimerHandle(timerType, 1);
            if (this.handle == null) {
                TestUtil.logTrace((String)"Null handle returned from initializeTimerHandle");
                return false;
            }
            if (!this.beanRef.cancelTimer(this.handle)) {
                TestUtil.logTrace((String)"Unable to cancel timer");
                return false;
            }
            return this.timerDoesNotExist();
        }
        catch (Exception e) {
            TimerImpl.handleException("initializeAndCancelTimer", e);
            return false;
        }
    }

    public boolean cancelAndRollback(int timerType) {
        try {
            TestUtil.logTrace((String)"Execute TestBeanLocal:initializeTimer");
            this.handle = this.beanRef.initializeTimerHandle(1, 1);
            if (this.handle == null) {
                return false;
            }
            TestUtil.logTrace((String)"Cancelling timer and rolling back cancellation...");
            this.beanRef.cancelAndRollback(this.handle);
            return this.timerExists();
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelAndRollback", e);
            return false;
        }
    }

    public boolean removeBeanWithTimers(int timerType) {
        int NUM_TIMERS = 4;
        TimerHandle[] handles = new TimerHandle[NUM_TIMERS];
        try {
            int i;
            TestUtil.logTrace((String)("Creating a set of " + NUM_TIMERS + " timers."));
            for (i = 0; i < NUM_TIMERS; ++i) {
                handles[i] = this.beanRef.initializeTimerHandle(timerType, -1);
            }
            TestUtil.logTrace((String)"Making sure we've got the right timers");
            for (i = 0; i < NUM_TIMERS; ++i) {
                if (handles[i] == null) {
                    TestUtil.logErr((String)("Null handle returned for timer " + i));
                    return false;
                }
                Serializable sz = handles[i].getTimer().getInfo();
                if (!(sz instanceof Integer)) {
                    TestUtil.logErr((String)("Non-integer info value returned for timer " + i));
                    return false;
                }
                int info = (Integer)sz;
                if (info == -1) continue;
                TestUtil.logErr((String)("Wrong info value received for timer " + i + ":\n  Expected:-1  Received:" + info));
                return false;
            }
            TestUtil.logTrace((String)"Removing the timer bean");
            this.beanRef.remove();
            TestUtil.logTrace((String)"Verifying the timers are gone with the bean");
            for (i = 0; i < NUM_TIMERS; ++i) {
                try {
                    handles[i].getTimer();
                }
                catch (NoSuchObjectLocalException nsole) {
                    TestUtil.logTrace((String)("Timer " + i + ": NoSuchObjectLocalException caught as expected"));
                    continue;
                }
                TestUtil.logErr((String)("Timer " + i + ": NoSuchObjectLocalException not caught as expected"));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("removeBeanWithTimers: Unexpected Exception", e);
            return false;
        }
    }

    public boolean timerExists() {
        TestUtil.logTrace((String)"Checking that timer still exists...");
        try {
            this.handle.getTimer();
            return this.handle != null;
        }
        catch (Exception e) {
            TimerImpl.handleException("timerExists: Exception caught accessing timer", e);
            return false;
        }
    }

    public boolean timerDoesNotExist() {
        TestUtil.logTrace((String)"Checking that timer no longer exists...");
        try {
            this.handle.getTimer();
        }
        catch (NoSuchObjectLocalException nsole) {
            TestUtil.logTrace((String)"NoSuchObjectLocalException caught as expected");
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("NoSuchObjectLocalException not caught as expected", e);
        }
        return false;
    }
}

